/*---------------------------------------------------------------------------*\

	FILE....: ADPCM.H
	TYPE....: Microsoft C Header
	AUTHOR..: Horse
	DATE....: 12/5/98

	ADPCM Functions for VLC card.

\*--------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

	Copyright (C) 1999 Voicetronix Pty Ltd

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

\*---------------------------------------------------------------------------*/

#ifndef __ADPCM__
#define __ADPCM__

#include "../contypes/contypes.h"

void adpcm_pack(ushort codes[], ushort packed[], ushort n);
void adpcm_unpack(ushort codes[], ushort packed[], ushort n);

void adpcm_open(void **states);
void adpcm_close(void *states);

void adpcm_encode(void *states, ushort codes[], short X[], ushort n);
void adpcm_decode(void *states, short X_[], ushort codes[], ushort n);

#endif
