/*---------------------------------------------------------------------------*\

    FILE....: DSPFIFO.H
    TYPE....: C Header File
    AUTHOR..: David Rowe
    DATE....: 20/11/97

    Functions used to read and write to First In First Out (DSPFIFO) queues in
    the DSP, thus facilitating PC to DSP data transfer.  The word length of
    the DSPFIFOs is 16 bits.

\*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

	Copyright (C) 1999 Voicetronix Pty Ltd

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

\*---------------------------------------------------------------------------*/

#ifndef __DSPFIFO__
#define __DSPFIFO__

#include "../contypes/contypes.h"
#include "../hip/hip.h"

/*--------------------------------------------------------------------------*\

								DEFINES

\*--------------------------------------------------------------------------*/

// Error codes 

#define OK				0	// no problems 				
#define	DSPFIFO_FULL	1	// DSP FIFO full			
#define	DSPFIFO_EMPTY	2	// DSP FIFO empty			

// direction of DSP FIFO (necessary for relay implementation)

#define DSPFIFO_UP		1
#define DSPFIFO_DOWN	0

// relay switch (in relay implementation we want message queues direct to DSPFIFO)

#define	RELAY_ON		1
#define	RELAY_OFF		0

/*-------------------------------------------------------------------------*\

								CLASS

\*-------------------------------------------------------------------------*/

class baseDspFifoData;

class DspFifo {
	baseDspFifoData	*d;
public:
	DspFifo(Hip *hip, ushort board, ushort fifo_addr, int direction, int relay);
	~DspFifo();
	int Write(word *buf, ushort size);
	int Read(word *buf, ushort size);
	int HowFull(void);
	int DspHowFull(void);
	int HowEmpty(void);
};

// functions

void dspfifo_open(ulong szRelayBuf);
void dspfifo_close();

#endif	// #ifndef __DSPFIFO__	

