
/*
    MEMTEST1.C
    David Rowe
    24/9/97

    Performs:
    1. Walking bit memory test of DSP SRAM.
    2. Test of autoincrement UP and DOWN.
*/

/*---------------------------------------------------------------------------*\

	Copyright (C) 1999 Voicetronix Pty Ltd

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

\*---------------------------------------------------------------------------*/

#include <dos.h>
#include <stdio.h>
#include <conio.h>
#include <stdlib.h>

#define BASE	0x310
#define	DATA	0x0
#define	CNTRL	0x1
#define	ADDLO	0x2
#define	ADDHI	0x3

#define	RESET	0x1
#define	CNTEN	0x2
#define	UP	0x4

#define LENGTH	0x10000

typedef unsigned short ushort;
void set_addr(ushort addr);

void main() {
    long	i,tests;
    ushort	j,valwr,valrd,addr,ahi,alo,valrd1,valrd2;
    ushort	cntrl;

    tests = 0;
    while(!kbhit()) {

	#define WALK
	#ifdef WALK

	/* Walking bit test */

	cntrl = RESET /*| !CNTEN | UP*/;
	outportb(BASE+CNTRL, cntrl);

	for(i=0; i<LENGTH; /*i++*/) {
	    addr = i;

	    if ((i % 0x1000) == 0)
		printf("\rWalking bit test addr = 0x%04x",addr);

	    set_addr(addr);

	    valwr = 0x1;
	    for(j=0; j<16; j++) {
		outport(BASE+DATA,valwr);
		valrd = inport(BASE+DATA);
		if (valrd != valwr) {
		    printf("\rError [0x%04x] = 0x%04x 0x%04x",addr,valwr,valrd);
//		    exit(0);
		}
//		valwr <<= 1;
	    }
	}
	#endif

//	#define AUTO_UP
	#ifdef AUTO_UP

	/* Autoincrement UP */

	printf("\n");
	outport(BASE+CNTRL, RESET | CNTEN | UP);

	set_addr(0x0);
	for(i=0; i<LENGTH; i++) {
	    addr = i;
	    valwr = i;
	    outport(BASE+DATA,valwr);
	}

	outport(BASE+CNTRL, RESET | CNTEN | UP);
	set_addr(0x0);
	for(i=0; i<LENGTH; i++) {
	    if ((i % 0x1000) == 0)
		printf("\rAutoincrement UP test addr = 0x%04x",addr);
	    addr++;

	    valwr = i;
	    valrd = inport(BASE+DATA);
	    if (valrd != valwr) {
		printf("\nError [0x%04x] = 0x%04x, should be 0x%04x\n",addr,valrd,valwr);
		/*exit(0);*/
	    }
	}
	#endif

//	#define AUTO_DOWN
	#ifdef AUTO_DOWN

	/* Autoincrement DOWN */

	printf("\n");
	outport(BASE+CNTRL, RESET | CNTEN | !UP);

	set_addr(0xffff);
	for(i=0; i<LENGTH; i++) {
	    valwr = i;
	    outport(BASE+DATA,valwr);
	}

	outport(BASE+CNTRL, RESET | CNTEN | !UP);
	set_addr(0xffff);
	for(i=0; i<LENGTH; i++) {
	    if ((i % 0x1000) == 0)
		printf("\rAutoincrement DOWN test addr = 0x%04x",addr);
	    addr--;

	    valwr = i;
	    valrd = inport(BASE+DATA);
	    if (valrd != valwr) {
		printf("\nError [0x%04x] = 0x%04x, should be 0x%04x\n",addr,valrd,valwr);
		/*exit(0);*/
	    }
	}
	#endif

	printf("\nTests Completed OK: %06ld\n",++tests);

    } /* while(!kbhit() .... */
}

void set_addr(ushort addr)
{
    outport(BASE+ADDLO,addr & 0xff);
    outport(BASE+ADDHI,(addr>>8) & 0xff);
}
