/*---------------------------------------------------------------------------*\

    FILE....: GENERIC.H
    TYPE....: C Functions
    AUTHOR..: David Rowe
    DATE....: 12/9/99

	This header file defines the interfaces of the generic functions
	that are used to access Operating System specific functions.

\*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

	Copyright (C) 1999 Voicetronix Pty Ltd

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

\*---------------------------------------------------------------------------*/

#ifndef __OS_SPECIFIC__
#define __OS_SPECIFIC__

// some WIN32 defines

#define METHOD_BUFFERED                 0
#define FILE_ANY_ACCESS                 0
#define FILE_WRITE_ACCESS         ( 0x0002 )
#define FILE_READ_ACCESS          ( 0x0001 )   
#define CTL_CODE( DeviceType, Function, Method, Access ) (((DeviceType) << 16) | ((Access) << 14) | ((Function) << 2) | (Method) )
#define	INVALID_HANDLE_FILE			NULL
#ifndef INVALID_HANDLE_VALUE
#define INVALID_HANDLE_VALUE        (void*)-1
#endif

// Critcal section functions

typedef struct {void *v; } GENERIC_CRITICAL_SECTION;	

void GenericInitializeCriticalSection(GENERIC_CRITICAL_SECTION *cs);
void GenericDeleteCriticalSection(GENERIC_CRITICAL_SECTION *cs);
void GenericEnterCriticalSection(GENERIC_CRITICAL_SECTION *cs);
void GenericLeaveCriticalSection(GENERIC_CRITICAL_SECTION *cs);

int GenericDeviceIoControl(
	void			*hndFile,	    // Handle to device
    long			IoctlCode,      // IO Control code for Read
    void			*InBuffer,		// Buffer to driver.
	long			InBufferSize,      
    void			*OutBuffer,     // Buffer from driver
    long			OutBufferSize,     
    unsigned long	*BytesReturned,	// no. bytes returned from driver
	void			*Overlapped		// not used, included for Win32 compatibility
);

void *GenericOpenMk0Driver();
void *GenericOpenMk1Driver();
int GenericCloseHandle(void *hndFile);

long GenerictimeGetTime();

// Get OS Type

#define GET_OS_WINDOWS_95	0
#define GET_OS_WINDOWS_NT	1
#define GET_OS_LINUX		2
#define	GET_OS_FAIL	-1

int GenericGetOS();

void GenericSleep(unsigned int ms);
void Generic_beginthread(void(*func)(void*), int stack, void *data);
void GenericSetThreadPriorityHigh();
void GenericSetThreadPriorityNormal();

// Linux Device driver
int Generic_add_board(int fd, void *data);
int Generic_remove_board(int fd, void *data);
int Generic_block_write(int fd, void *data);
int Generic_block_read(int fd, void *data);
int Generic_open();
int	Generic_close(int fd);

#endif
