/*---------------------------------------------------------------------------*\

    FILE....: GenericWINNT.CPP
    TYPE....: C Functions
    AUTHOR..: David Rowe
    DATE....: 12/9/99

	Win NT implementation of Generic functions.

\*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

	Copyright (C) 1999 Voicetronix Pty Ltd

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

\*---------------------------------------------------------------------------*/

#include <assert.h>
#include <windows.h>
#include <mmsystem.h>
#include <process.h>
#include "../generic/generic.h"

void GenericInitializeCriticalSection(GENERIC_CRITICAL_SECTION *cs) {
	cs->v = (void*)new CRITICAL_SECTION;
	assert(cs->v != NULL);
	InitializeCriticalSection((LPCRITICAL_SECTION)cs->v);
}

void GenericDeleteCriticalSection(GENERIC_CRITICAL_SECTION *cs) {
	DeleteCriticalSection((LPCRITICAL_SECTION)cs->v);
	delete cs->v;
}

void GenericEnterCriticalSection(GENERIC_CRITICAL_SECTION *cs)  {
	EnterCriticalSection((LPCRITICAL_SECTION)cs->v);
}

void GenericLeaveCriticalSection(GENERIC_CRITICAL_SECTION *cs)  {
	LeaveCriticalSection((LPCRITICAL_SECTION)cs->v);
}

int GenericDeviceIoControl(
	void			*hndFile,	    // Handle to device
    long			IoctlCode,      // IO Control code for Read
    void			*InBuffer,		// Buffer to driver.
	long			InBufferSize,      
    void			*OutBuffer,     // Buffer from driver
    long			OutBufferSize,     
    unsigned long	*BytesReturned,	// no. bytes returned from driver
	void			*Overlapped		// not used, included for Win32 compatibility
)
{
	return DeviceIoControl(
				hndFile,	     // Handle to device
				IoctlCode,       // IO Control code for Read
				InBuffer,		 // Buffer to driver.
				InBufferSize,      
				OutBuffer,       // Buffer from driver
				OutBufferSize,     
				BytesReturned,	 // no. bytes returned from driver
				NULL			 // not used, included for Win32 compatibility
			);

}

// Open basic (ddmodel==0 in vpbreg) NT driver that just gives port I/O
void *GenericOpenMk0Driver()
{
	return CreateFile(
				"\\\\.\\GpdDev",           
                GENERIC_WRITE | GENERIC_READ,
                FILE_SHARE_WRITE,
                NULL,
                OPEN_EXISTING,
                0,
                NULL);
}

// Open relay buffer (ddmodel==1 in vpbreg) NT driver 
void *GenericOpenMk1Driver()
{
	return CreateFile(
					"\\\\.\\VpbDev",           
                    GENERIC_WRITE | GENERIC_READ,
                    FILE_SHARE_WRITE,
                    NULL,
                    OPEN_EXISTING,
                    0,
                    NULL);
}

int GenericCloseHandle(void *hndFile) {
	return CloseHandle(hndFile);
}

long GenerictimeGetTime() {
	return timeGetTime();
}

// determies OS, returns -1 for fail

int GenericGetOS() {
	OSVERSIONINFO os;		// operating system info

	os.dwOSVersionInfoSize = sizeof(OSVERSIONINFO);
	BOOL ret = GetVersionEx(&os);
	if (ret == 0)
		return GET_OS_FAIL;
	
	switch(os.dwPlatformId) {
		case VER_PLATFORM_WIN32_WINDOWS:
			return GET_OS_WINDOWS_95;
		break;
		case VER_PLATFORM_WIN32_NT:
			return GET_OS_WINDOWS_NT;
		break;
		default:
			return GET_OS_FAIL;
	}

	// should never get here

	return GET_OS_FAIL;
}

void GenericSleep(unsigned int ms)
{
	Sleep(ms);
}

void Generic_beginthread(void(*func)(void*), int stack, void *data) {
	_beginthread(func, stack, data);
}

void GenericSetThreadPriorityHigh() {
	HANDLE h = GetCurrentThread();
	assert(SetThreadPriority(h,THREAD_PRIORITY_TIME_CRITICAL)==TRUE);
}

void GenericSetThreadPriorityNormal() {
	HANDLE h = GetCurrentThread();
	assert(SetThreadPriority(h,THREAD_PRIORITY_NORMAL)==TRUE);
}

// Linux device driver - do nothing in NT implementation
int Generic_add_board(int fd, void *data) { return 0; }
int Generic_remove_board(int fd, void *data) { return 0; }
int Generic_block_write(int fd, void *data) { return 0; }
int Generic_block_read(int fd, void *data) { return 0; }
int Generic_open() { return 0; }
int	Generic_close(int fd) { return 0; }

