/*--------------------------------------------------------------------------*\

    FILE....: PORT.C
    TYPE....: C Functions
    AUTHOR..: David Rowe
    DATE....: 30/9/97

    Turbo C DOS version of low level port I/O functions.

\*--------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

	Copyright (C) 1999 Voicetronix Pty Ltd

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

\*---------------------------------------------------------------------------*/

/*-------------------------------------------------------------------------*\

				 INCLUDES

\*-------------------------------------------------------------------------*/

#include <conio.h>
#include <stdio.h>
#include "..\portc.h"
#include "..\..\vxd\vxd.h"

#pragma intrinsic (_outpw,_inpw)

/*-------------------------------------------------------------------------*\

				FUNCTIONS

\*-------------------------------------------------------------------------*/

/*-------------------------------------------------------------------------*\

    FUNCTION.: port_open
    AUTHOR...: David Rowe
    DATE.....: 30/9/97

    Performs device driver initialisation for a given VPB.

\*-------------------------------------------------------------------------*/

void port_open(ushort base, ushort span)
/*  ushort base		base address of VPB		*/
/*  ushort span		number of I/O ports used	*/
{
}

/*-------------------------------------------------------------------------*\

    FUNCTION.: port_close
    AUTHOR...: David Rowe
    DATE.....: 30/9/97

    Closes down the port I/O driver.  Must be called before exiting
    the program.  Dummy function for DOS.

\*-------------------------------------------------------------------------*/

void port_close(void)
{
}

/*-------------------------------------------------------------------------*\

    FUNCTION.: port_write
    AUTHOR...: David Rowe
    DATE.....: 30/9/97

    Writes a single 16-bit word to a 16-bit I/O port.

\*-------------------------------------------------------------------------*/

void port_write(ushort port, word value)
/*  ushort port;	port address		*/
/*  word   value;	value to write		*/
{
    assert((port >= START_BASE) && (port < END_BASE));
    _outpw(port,value);
}

/*-------------------------------------------------------------------------*\

    FUNCTION.: port_block_write
    AUTHOR...: David Rowe
    DATE.....: 30/9/97

    Writes a block of 16-bit words to a 16-bit I/O port.  The length and
    value is specified in words (not bytes).

\*-------------------------------------------------------------------------*/

void port_block_write(ushort port, ulong length, word *buf)
/*  ushort base;	port address		*/
/*  ulong  length;	length of block		*/
/*  word   *buf;	ptr to block in PC	*/
{
    ulong  i;

    /* validate arguments */

    assert((port >= START_BASE) && (port < END_BASE));
    assert(length < MAX_LENGTH);
    assert(buf != NULL);

    /* perform block write */

    for(i=0; i<length; i++)
	_outpw(port,*buf++);
}

/*-------------------------------------------------------------------------*\

    FUNCTION.: port_block_read
    AUTHOR...: David Rowe
    DATE.....: 30/9/97

    Reads a block of 16-bit words from a 16-bit I/O port.  The length and
    value is specified in words (not bytes).

\*-------------------------------------------------------------------------*/

void port_block_read(ushort port, ulong length, word *buf)
/*  ushort base;	port address		*/
/*  ulong  length;	length of block		*/
/*  word   *buf;	ptr to block in PC	*/
{
    ulong  i;

    /* validate arguments */

    assert((port >= START_BASE) && (port < END_BASE));
    assert(length < MAX_LENGTH);
    assert(buf != NULL);

    /* perform block read */

    for(i=0; i<length; i++)
	*buf++ = _inpw(port);
}


