// gpioctl.h    Include file for Generic Port I/O Example Driver
//
// Define the IOCTL codes we will use.  The IOCTL code contains a command
// identifier, plus other information about the device, the type of access
// with which the file must have been opened, and the type of buffering.
//
// Robert B. Nelson (Microsoft)     March 1, 1993

// Device type           -- in the "User Defined" range."

/*---------------------------------------------------------------------------*\

	Copyright (C) 1999 Voicetronix Pty Ltd

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

\*---------------------------------------------------------------------------*/

#include "../contypes/contypes.h"

#define GPD_TYPE 0x8000		

// The IOCTL function codes from 0x800 to 0xFFF are for customer use.

#define IOCTL_GPD_READ_PORT_USHORT CTL_CODE( GPD_TYPE, 0x901, METHOD_BUFFERED, FILE_READ_ACCESS )

#define IOCTL_GPD_WRITE_PORT_USHORT CTL_CODE(GPD_TYPE,  0x911, METHOD_BUFFERED, FILE_WRITE_ACCESS)

// new stuff added bt DR 15/11/97

#define IOCTL_GPD_ALLOCATE_PORTS CTL_CODE(GPD_TYPE,  0x913, METHOD_BUFFERED, FILE_WRITE_ACCESS)

// Structure that defines the block of ports required by each VPB in terms
// of the VPBs base address and span.

typedef struct {
	ushort	base;		// base address
	ushort	span;		// number of ports
} BLOCK,*PBLOCK;

// Structure that holds a list of blocks.  This structure is used to
// communicate with the device driver via DeviceIoControl.

typedef struct {
	long	blocks;
	BLOCK	block[MAX_VPB];
} BLOCKLIST, *PBLOCKLIST;

#define	PORT	3		// size of port desription info in USHORTS
