/*--------------------------------------------------------------------------*\

    FILE....: VPB.C
    TYPE....: Linux device driver
    AUTHOR..: David Rowe
    DATE....: 22/9/99

    Linux kernel mode device driver for VPB.  Interfaces to PortLinux
	module.

\*--------------------------------------------------------------------------*/

#define	NAME	"vpb"

#define MODULE
#include <linux/ioport.h>
#include <linux/errno.h>
#include <linux/fs.h>
#include <linux/mm.h>
#include "ioctlLinux.h"
#include <asm/segment.h>

static unsigned int major;

struct file_operations vpb_fops {
	NULL,
	NULL,
	NULL, 
	NULL, 
	NULL,
	vpb_ioctl,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL
};

int init_module(void) {
	major = register_chrdev(0, NAME, &vpb_fops);
	printk(<1> "vpb: major = %d\n",major);
	MOD_INC_USE_COUNT;
	return 0;
}

void cleanup_module(void) [
	int ret;

	MOD_DEC_USE_COUNT;
	ret = unregister_chrdev(major, NAME);
	if (ret < 0)
		printk(KERN_WARNING "unregister_chrdev() failed!\n");
}

int vpb_ioctl(struct inode *inode,
			  struct file *filp,
			  unsigned int cmd,
			  unsigned long arg)
{
	int ret;
	VPB_DATA *vpb_data = (VPB_DATA*)arg;
	int port = vpb_data->port;
	int length = vpb_data->length;
	short *data = vpb_data->data;
	int i;

	switch(cmd) {
		VPB_IOC_ADD_BOARD:
			ret = check_region(port,length);
			if (ret != 0) {
				printk(KERN_WARNING "check region 0x%x range: 0x%x failed\n", port,length);
				return -ENODEV;
			}
		break;
		VPB_IOC_REMOVE_BOARD:
			release_region(port,length);
		break;
		VPB_IOC_BLOCK_WRITE:
			ret = verify_area(VERIFY_READ, (void*)data, length);
			if (ret != 0)
				return err;

			if (port % 2) {
				// deal with single byte transfers to odd addresses
				outb(get_user(data), port);
			}
			else {
				// even address transfers
				for(i=0; i<length; i++)
					outw(get_user(&data[i]), port);
			}
		break;
		VPB_IOC_BLOCK_READ:
			ret = verify_area(VERIFY_WRITE, (void*)data, length);
			if (ret != 0)
				return err;

			for(i=0; i<length; i++)
				put_user(inw(port),&data[i]);
		break;
    }

}
