/*---------------------------------------------------------------------------*\

    FILE....: DSPFIFO.H
    TYPE....: C Header File
    AUTHOR..: David Rowe
    DATE....: 20/11/97

    Functions used to read and write to First In First Out (DSPFIFO) queues in
    the DSP, thus facilitating PC to DSP data transfer.  The word length of
    the DSPFIFOs is 16 bits.

\*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

	Copyright (C) 1999 Voicetronix Pty Ltd

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

\*---------------------------------------------------------------------------*/

#ifndef __DSPFIFO__
#define __DSPFIFO__

#include "..\contypes\contypes.h"

/*--------------------------------------------------------------------------*\

								DEFINES

\*--------------------------------------------------------------------------*/

// Error codes 

#define OK				0	// no problems 				
#define	DSPFIFO_FULL	1	// DSP FIFO full			
#define	DSPFIFO_EMPTY	2	// DSP FIFO empty			

/*-------------------------------------------------------------------------*\

								STRUCTURES

\*-------------------------------------------------------------------------*/

// Normally, this implementation specific info would be hidden in the
// dspfifo.c module.  However in this case it is easier to have this info
// exposed so that storage for the fifos can be allowed for in the
// device context, as individual mallocs are very messy in NT device
// driver land.

#pragma pack(1)		// force member alignment same as DSP

typedef struct {
    // copy of FIFO parameters in DSP memory 

    word	pstart;		// first word in FIFO			
    word	pend;		// one after last word in FIFO		
    word	pwr;		// write pointer			
    word	prd; 		// read pointer				
    ushort	size;		// total storage in FIFO		

    // extra params for PC only 

	ushort	board;		// VPB board number			
    ushort	adspfifo;	// address of structure in DSP memory	
} DSP_FIFO,*PDSP_FIFO;

#pragma pack()	// normal member alignment

/*-------------------------------------------------------------------------*\

								CLASS

\*-------------------------------------------------------------------------*/

void DspFifoOpen(PDSP_FIFO df, ushort board, ushort fifo_addr);
void DspFifoClose(PDSP_FIFO df);
int DspFifoWrite(PDSP_FIFO df, word *buf, ushort size);
int DspFifoRead(PDSP_FIFO df, word *buf, ushort size);
ushort DspFifoHowFull(PDSP_FIFO df);
ushort DspFifoHowEmpty(PDSP_FIFO df);

#endif	// #ifndef __DSPFIFO__	

