/*---------------------------------------------------------------------------*\

    FILE....: FIFO.H
    TYPE....: C++ Header File
    AUTHOR..: David Rowe
    DATE....: 5/10/98

    Header file for NT DD module FIFO.C.

\*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

	Copyright (C) 1999 Voicetronix Pty Ltd

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

\*---------------------------------------------------------------------------*/

#ifndef __FIFO__
#define __FIFO__

#include "..\contypes\contypes.h"
#include <ntddk.h>

/*--------------------------------------------------------------------------*\

								DEFINES

\*--------------------------------------------------------------------------*/

// Error codes 

#define FIFO_OK		0	// no problems 				
#define	FIFO_FULL	1	// FIFO full				
#define	FIFO_EMPTY	2	// FIFO empty				
#define	FIFO_ERROR	-1	// problem opening

/*--------------------------------------------------------------------------*\

				TYPEDEFS

\*--------------------------------------------------------------------------*/

// Normally, this implementation specific info would be hidden in the
// fifo.c module.  However in this case it is easier to have this info
// exposed so that storage for the fifos can be allowed for in the
// device context, as individual mallocs are very messy in NT device
// driver land.

typedef struct {
    word   *pstart;		// first word in FIFO			
    word   *pend;		// one after last word in FIFO		
    word   *pwr;		// write pointer			
    word   *prd; 		// read pointer				
    ulong  size;		// total storage in FIFO		
	PMDL   pMdl;		// memory descriptor list for fifo buffer
	ushort locked;		// non-zero if memory locked
} PC_FIFO,*PPC_FIFO;

/*-------------------------------------------------------------------------*\

								FUNCTIONS

\*-------------------------------------------------------------------------*/

int FifoCreate(PC_FIFO *pfifo, PVOID *buf, ulong size);
void FifoDestroy(PC_FIFO *pvfifo);
int FifoWrite(PC_FIFO *pfifo, word *buf, ushort size);
int FifoRead(PC_FIFO *vfifo, word *buf, ushort size);
int FifoHowFull(PC_FIFO *pfifo);
int FifoHowEmpty(PC_FIFO *pfifo);

#endif	// #ifndef __FIFO__

