/*--------------------------------------------------------------------------*\

    FILE....: HIP.H
    TYPE....: C++ Module Header File
    AUTHOR..: David Rowe
    DATE....: 2/10/98

    VPB access functions for NT device driver.

\*--------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

	Copyright (C) 1999 Voicetronix Pty Ltd

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

\*---------------------------------------------------------------------------*/

#ifndef __HIP__
#define __HIP__

#include "..\contypes\contypes.h"

#define HIP_OK		1
#define	HIP_FAIL	0

void HipOpen(void *Context);
void HipClose(void *Context);
int  HipInitVpb(void *Context, ushort base);
void HipDspReset(ushort board);
void HipDspRun(ushort board);
void HipWriteDspSram(ushort board, ushort addr, ushort length, word *buf);
void HipReadDspSram(ushort board, ushort addr, ushort length, word *buf);
void HipSetPip(ushort board, char enables);

#endif	// #ifndef __HIP__

