/*--------------------------------------------------------------------------*\

    FILE....: PORT.H
    TYPE....: C Module
    AUTHOR..: David Rowe
    DATE....: 2/10/98

	Win NT device driver port module.

\*--------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

	Copyright (C) 1999 Voicetronix Pty Ltd

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

\*---------------------------------------------------------------------------*/

#ifndef __PORT__
#define	__PORT__

#include "..\contypes\contypes.h"

#define	PORT_OK		1
#define	PORT_FAIL	0

void port_open();
void port_close(void *Context);
int port_add_board(void *Context, ushort base, ushort span);
void port_write(ushort board, ushort offset, ushort value);
void port_block_write(ushort board, ushort offset, ushort length, ushort *buf);
void port_block_read(ushort board, ushort offset, ushort length, ushort *buf);

#endif	// __PORT__
