/*---------------------------------------------------------------------------*\

    FILE....: RELAYFIFO.H
    TYPE....: C Header File
    AUTHOR..: David Rowe
    DATE....: 7/10/98

    Functions used to implement Kernal mode buffering of the DSP Fifos.
	These fifos relay data from the DSP fifos to a large buffer in PC
	memory that mimics a large "virtual" dsp fifo for the user mode 
	driver software.

\*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

	Copyright (C) 1999 Voicetronix Pty Ltd

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

\*---------------------------------------------------------------------------*/

#ifndef __RELAYFIFO__
#define __RELAYFIFO__

#include "..\contypes\contypes.h"
#include "vpb.h"

#define	RELAY_FIFO_OK	0
#define	RELAY_FIFO_FAIL	-1

int RelayFifoOpen(PFIFO f, PFIFO_PARAMS fp);
void RelayFifoClose(PFIFO f);
int RelayFifoHowFull(PFIFO f);
void RelayFifoRelay(PFIFO f);

#endif	// #ifndef __RELAYFIFO__	

