/*---------------------------------------------------------------------------*\

	FILE....: TPORT.C
	TYPE....: C Module
	AUTHOR..: David Rowe
	DATE....: 2/10/98

	Test function for PORT.C module.

\*--------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

	Copyright (C) 1999 Voicetronix Pty Ltd

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

\*---------------------------------------------------------------------------*/

#include "tport.h"
#include "port.h"

// HIP registers 

#define	DATA		0x0		// offset of data register	
#define	CNTRL		0x1		// offset of control register	
#define	ADDRLO		0x2		// low byte of address register	
#define	ADDRHI		0x3		// hi byte of address register	

// Control register bits 

#define	RESET		0x1		// assert to place DSP in reset	
#define	CNTEN		0x2		// assert to enable addr cntr	
#define UP			0x4		// ==1 for up count, else down	

#define	SPAN		0x4		
#define	ADDR		0x0		// base address for mem test

#define	BASE		0x330	// base address of test card
#define	BOARD		0		// board number for test
#define	LENGTH		0x100	// LENGTH of test

/*-------------------------------------------------------------------------*\

    FUNCTION.: tport_tport
    AUTHOR...: David Rowe
    DATE.....: 2/10/98

	Performs a simple memory test on a VPB card using the PORT I/O
	functions.  Returns STATUS_SUCCESS for success.

\*--------------------------------------------------------------------------*/

NTSTATUS tport_tport(PDRIVER_OBJECT DriverObject)
{
    int			ret,i;
    ushort		cntrl;
    word		bufwr[LENGTH],bufrd[LENGTH];
	NTSTATUS	status;

    // initalise 

    port_open(DriverObject);
	status = port_add_board(DriverObject, BASE, SPAN);
	if (!NT_SUCCESS(status))
		return status;

    cntrl = RESET | CNTEN | UP;
    port_write(BOARD, CNTRL, cntrl);
    for(i=0; i<LENGTH; i++)
		bufwr[i] = i;

    // write block,then read back and check 

    port_write(BOARD, ADDRLO,ADDR & 0xff);
    port_write(BOARD, ADDRHI,(ADDR>>8) & 0xff);
    port_block_write(BOARD, DATA, LENGTH, bufwr);
    port_write(BOARD, ADDRLO,ADDR & 0xff);
    port_write(BOARD, ADDRHI,(ADDR>>8) & 0xff);
    port_block_read (BOARD, DATA, LENGTH, bufrd);

    for(i=0; i<LENGTH; i++) {
		if (bufwr[i] != bufrd[i]) {
			return STATUS_INVALID_PARAMETER;
		}
	}

    // clean up and finish 

    port_close(DriverObject);

    return STATUS_SUCCESS;
}

