/*---------------------------------------------------------------------------*\

    FILE....: VPB.H
    TYPE....: C Module
    AUTHOR..: David Rowe
    DATE....: 1/10/98

    Windows NT Device Driver for Voicetronix VPB cards.

\*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

	Copyright (C) 1999 Voicetronix Pty Ltd

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

\*---------------------------------------------------------------------------*/

#ifndef __VPB__
#define __VPB__

#include <ntddk.h>
#include <string.h>
#include <devioctl.h>
#include "..\vpbioctl.h"			// Get IOCTL interface definitions
#include "fifo.h"					// PC fifo states
#include "dspfifo.h"				// DSP fifo states

#define	TIME_SCALE		(10*1000)	// converts 100ns to ms
#define	MAX_FIFO		(10*32)		// 8 fifos per (VPB4 or 8L) card, up to 32 cards
		
#if DBG 
    #define DBGPRINT( args ) DbgPrint args 
#else 
    #define DBGPRINT( args ) 
#endif 

// NT device name
#define VPB_DEVICE_NAME L"\\Device\\Vpb0"

// File system device name.   When you execute a CreateFile call to open the
// device, use "\\.\VpbDev", or, given C's conversion of \\ to \, use
// "\\\\.\\VpbDev"

#define DOS_DEVICE_NAME L"\\DosDevices\\VpbDev"

// The PC FIFOs are a block of user memory that is manipulated
// by the system level (device driver) code.  The user mode code
// first allocates the buffer, the system level code is then used
// for all access using DeviceIoctl's that map through the ring 3/ring 0
// boundary to the regular fifo access functions.

// structure that contains info necessary to work with PC fifo in
// system view

typedef struct {
	PC_FIFO		PcFifo;				// PC fifo states  
	DSP_FIFO	DspFifo;			// DSP fifo states  
	ushort		direction;			// direction of relay
	ushort		dsponly;			// non-zero if this is a DSP only FIFO (no relay)
} FIFO, *PFIFO;

// driver local data structure specific to each device object

typedef struct _LOCAL_DEVICE_INFO {
    ULONG               DeviceType;					// Our private Device Type
    PDEVICE_OBJECT      DeviceObject;				// The Vpb device object.
	HANDLE				ThreadHandle;				// handle of system thread
	USHORT				KillThread;					// set to TRUE to get thread to self-destruct
	USHORT				MaxTardiness;				// Keeps track of tardiness
	FIFO				Fifo[MAX_FIFO];				// list of Fifos
	USHORT				nFifo;						// number of Fifos
	KSPIN_LOCK			LocknFifo;					// guards access to nFifo
	KEVENT				DeadThread;					// set when thread is dead! (in response to KillThread)
} LOCAL_DEVICE_INFO, *PLOCAL_DEVICE_INFO;

/********************* function prototypes ***********************************/
//

NTSTATUS    DriverEntry(       IN  PDRIVER_OBJECT DriverObject,
                               IN  PUNICODE_STRING RegistryPath );

NTSTATUS    VpbCreateDevice(   IN  PWSTR szPrototypeName,
                               IN  DEVICE_TYPE DeviceType,
                               IN  PDRIVER_OBJECT DriverObject,
                               OUT PDEVICE_OBJECT *ppDevObj     );

NTSTATUS    VpbDispatch(       IN  PDEVICE_OBJECT pDO,
                               IN  PIRP pIrp                    );

NTSTATUS    VpbProcessIoctl(   IN  PLOCAL_DEVICE_INFO pLDI,
                               IN  PIRP pIrp,
                               IN  PIO_STACK_LOCATION IrpStack,
                               IN  ULONG IoctlCode,
							   IN PDRIVER_OBJECT DriverObject
							   );

VOID        VpbUnload(         IN  PDRIVER_OBJECT DriverObject );

VOID VpbThreadMain(			   IN PVOID	Context );

void VpbSetnFifo(PLOCAL_DEVICE_INFO pLDI, ushort val);
ushort VpbGetnFifo(PLOCAL_DEVICE_INFO pLDI);

#endif	// __VPB__
