/*---------------------------------------------------------------------------*\

    FILE....: PORT.H
    TYPE....: C++ Header
    AUTHOR..: David Rowe
    DATE....: 14/11/97

    Low level port I/O module interface.

\*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

	Copyright (C) 1999 Voicetronix Pty Ltd

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

\*---------------------------------------------------------------------------*/

#ifndef __PORT__
#define __PORT__

#include "../contypes/contypes.h"

/*-------------------------------------------------------------------------*\

			   MODULE INTERFACE

\*-------------------------------------------------------------------------*/

// generic port base class, functions are virtualised depending on
// operating system

class Port {
public:
    virtual void addBoard(ushort base, ushort span) = 0;
    virtual void write(ushort board, ushort offset, word value) = 0;
    virtual void blockWrite(ushort board, ushort offset, ushort length, word *buf) = 0;
    virtual void blockRead(ushort board, ushort offset, ushort length, word *buf) = 0;
};

// Windows 95 implementation ------------------------------------------

class PortDataWin95;

class PortWin95 : public Port {
    PortDataWin95 *d;
public:
    PortWin95();
    ~PortWin95();
    void addBoard(ushort base, ushort span);
    void write(ushort board, ushort offset, word value);
    void blockWrite(ushort board, ushort offset, ushort length, word *buf);
    void blockRead(ushort board, ushort offset, ushort length, word *buf);
};

// Windows NT implementation ------------------------------------------

class PortDataWinNT;

class PortWinNT : public Port {
    PortDataWinNT *d;
public:
    PortWinNT();
    ~PortWinNT();
    void addBoard(ushort base, ushort span);
    void write(ushort board, ushort offset, word value);
    void blockWrite(ushort board, ushort offset, ushort length, word *buf);
    void blockRead(ushort board, ushort offset, ushort length, word *buf);
};

// Linux implementation ------------------------------------------

class PortDataLinux;

class PortLinux : public Port {
    PortDataLinux *d;
public:
    PortLinux();
    ~PortLinux();
    void addBoard(ushort base, ushort span);
    void write(ushort board, ushort offset, word value);
    void blockWrite(ushort board, ushort offset, ushort length, word *buf);
    void blockRead(ushort board, ushort offset, ushort length, word *buf);
};

#endif	/* #ifndef __PORT__	*/

