/*---------------------------------------------------------------------------*\

    FILE....: PORT.H
    TYPE....: C Function Header File
    AUTHOR..: David Rowe
    DATE....: 30/9/97

    Low level port I/O functions.

\*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

	Copyright (C) 1999 Voicetronix Pty Ltd

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

\*---------------------------------------------------------------------------*/

#ifndef __PORT__
#define __PORT__

#include "..\contypes\contypes.h"

/*-------------------------------------------------------------------------*\

			 FUNCTION HEADERS

\*-------------------------------------------------------------------------*/

void port_open(ushort base, ushort span);
void port_close(void);
void port_write(ushort port, word value);
void port_block_write(ushort port,  ulong length, word *buf);
void port_block_read(ushort port, ulong length, word *buf);

#endif	/* #ifndef __PORT__	*/

