/*---------------------------------------------------------------------------*\

    FILE....: MESS.CPP
    TYPE....: WIN32 Function File
    AUTHOR..: John Kostogiannis
    DATE....: 20/11/97

    Interface functions for messages.  Messages are information sent by
    various modules to a message window just like printf to the console. 
	
	DR 12/9/99:
	Removed all Windows stuff for Linux port.  These functions were used
	mainly for console-mode debug anyway.

\*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

	Copyright (C) 1999 Voicetronix Pty Ltd

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

\*---------------------------------------------------------------------------*/


#include <assert.h>
#include <stdlib.h>
#include <stdio.h>
#include <stdarg.h>

#include "../message/mess.h"

#include "../wobbly/wobbly.h"

/*-------------------------------------------------------------------------*\

				DEFINES

\*-------------------------------------------------------------------------*/

#define MAXLINESOFMESS	100

/*-------------------------------------------------------------------------*\

				STATICS

\*-------------------------------------------------------------------------*/

static int enable;
static int file_enable;

static FILE *file;

/*-------------------------------------------------------------------------*\

			       FUNCTIONS

\*-------------------------------------------------------------------------*/

/*-------------------------------------------------------------------------*\

    FUNCTION.: mprintf_on
    AUTHOR...: John Kostogiannis
    DATE.....: 20/11/97

    This functions pops ups a message window. It returns the handle of this
	window.
	

\*-------------------------------------------------------------------------*/
void mess_mprintf_on(int h,int hInt){

	enable = OFF;
	file_enable = OFF;
}

/*-------------------------------------------------------------------------*\

    FUNCTION.: mprintf_on
    AUTHOR...: John Kostogiannis
    DATE.....: 20/11/97
	Enables mprintf statements.  Either this function of mprintf_off should
	be called during program initialisation to place the mprintf functions
	in a known state.

\*-------------------------------------------------------------------------*/

void mess_mprintf_on(void){
    enable = ON;
	file_enable = OFF;
}

/*-------------------------------------------------------------------------*\

    FUNCTION.: mprintf_on
    AUTHOR...: John Kostogiannis
    DATE.....: 20/11/97
	Enables mprintf statements in a dos shell and loading to a file.
	Either this function of mprintf_off should
	be called during program initialisation to place the mprintf functions
	in a known state.

\*-------------------------------------------------------------------------*/

void mess_mprintf_on(char *fn){
    enable = ON;
	file_enable = ON;
	file = fopen(fn,"wt");
}

/*-------------------------------------------------------------------------*\

    FUNCTION.: mprintf_on
    AUTHOR...: John Kostogiannis
    DATE.....: 20/11/97
	Enables mprintf statements to be loaded to a file. Gives options on whether
	whether to append etc.
	Either this function of mprintf_off should
	be called during program initialisation to place the mprintf functions
	in a known state.

\*-------------------------------------------------------------------------*/

void mess_mprintf_on(char *fn, char *s){
    enable = ON;
	file_enable = ON;
	file = fopen(fn,s);
}


/*-------------------------------------------------------------------------*\

    FUNCTION.: mprintf_off
    AUTHOR...: John Kostogiannis
    DATE.....: 20/11/97

    Disables mprintf statements.  Either this function or mprintf_on should
    be called during program initialisation to place the mprintf functions
    in a known state.

\*-------------------------------------------------------------------------*/


void mess_mprintf_off(void)
{
	enable = OFF;
	if(file_enable == ON){
		file_enable = OFF;
		fclose(file);
	}
}
	

/*-------------------------------------------------------------------------*\

    FUNCTION.: mprintf
    AUTHOR...: John Kostogiannis
    DATE.....: 20/11/97

    Prints the message info to the Message Window. If enable is on it prints
	the message info to the console.


\*-------------------------------------------------------------------------*/


void mprintf(char *fmt, ...)
{
	va_list argptr;

	if(enable) {
       va_start(argptr, fmt);
       vprintf(fmt, argptr);
	   if(file_enable) {
		 vfprintf(file,fmt,argptr);
	   }
       va_end(argptr);
   }

}

