/*---------------------------------------------------------------------------*\

	FILE....: TCOMM.CPP
	TYPE....: Microsoft C Program
	AUTHOR..: David Rowe
	DATE....: 19/11/97

	Test program for communicating with VPB DSP.  Gives the following
	modules a work out:

	PORT.CPP
	HIP.CPP
	COFF.CPP
	DSPFIFO.CPP
	VPBREG.CPP
	COMM.CPP

\*--------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

	Copyright (C) 1999 Voicetronix Pty Ltd

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

\*---------------------------------------------------------------------------*/

#include "..\message\mess.h"
#include "..\comm\comm.h"
#include "..\timer\timer.h"
#include "..\wobbly\wobbly.h"

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#ifdef WIN32
#include <conio.h>
#include <crtdbg.h>
#endif

#define WAIT		1	// time out delay 
#define	BOARD		0	// which board in VPB Registry to use

void main()
{
    word		dnmess[PC_LPING];
    word		upmess[PC_LPING];
    long		pings,pongs;
    ushort      pongok;

    // initialise 

    try {
		Timer	timer, timer1;

		mess_mprintf_on();

		Comm comm;

		// construct "ping" message
		
		dnmess[0] = PC_LPING;
		dnmess[1] = PC_PING;

		pings = 0;
		pongs = 0;

#ifdef WIN32
		while(!kbhit()) {
#else
		while(1) {
#endif		
			// send message 

			comm.PutMessageVPB(BOARD, dnmess);
			pings++;

			// wait for message from DSP 

			while(comm.GetMessageVPB(BOARD, upmess) == OK) {
				pongok = (upmess[0] == DSP_LPONG) && (upmess[1] == DSP_PONG);
				if (pongok)
					pongs++;
			}

			printf("pings [%ld] pongs [%ld]\r",pings, pongs);
		} // while(...
	}	// try ...

    catch (Wobbly w) {
		char	s[MAX_STR];
		w.translate(s);
		printf("exception caught: %s, file: %s line:%d\n",s,w.file,w.line);
		exit(1);
    }

#ifdef WIN32
    if(_CrtDumpMemoryLeaks())
		printf("\nBummer - memory leak\n");
    else
        printf("\nComms test passed OK!\n");
#endif
}

