/*---------------------------------------------------------------------------*\

    FILE....: DIGBUF.H
    TYPE....: C++ Header file
    AUTHOR..: David Rowe
    DATE....: 22/4/98

	Classes that implement Computer Telephony (CT) "DIGBUF", high level
	classes for developing CT apps.  These classes sit on top of the
	VPB API, and are modelled on the VB voice controls.
	 
\*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

	Copyright (C) 1999 Voicetronix Pty Ltd

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

\*---------------------------------------------------------------------------*/

#ifndef __DIGBUF__
#define __DIGBUF__

#include "../contypes/contypes.h"

// digbuf_read return codes 

#define OK				0 				
#define	DIGBUF_EMPTY	2

// function headers

void *digbuf_open(ushort numch, ushort size);
void digbuf_write(void *digbuf, ushort chdev, ushort digit);
int digbuf_read(void *digbuf, ushort chdev, ushort *digit);
void digbuf_clear(void *digbuf, ushort chdev);
void digbuf_close(void *digbuf);

#endif	// __DIGBUF__
