/*---------------------------------------------------------------------------*\

    FILE....: FIFO.H
    TYPE....: C++ Header File
    AUTHOR..: David Rowe
    DATE....: 19/11/97

    Functions used to implement First In First Out (FIFO) queues of 16 bit
    words.

\*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

	Copyright (C) 1999 Voicetronix Pty Ltd

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

\*---------------------------------------------------------------------------*/

#ifndef __FIFO__
#define __FIFO__

#include "..\contypes\contypes.h"

/*--------------------------------------------------------------------------*\

								DEFINES

\*--------------------------------------------------------------------------*/

// Error codes 

#define OK			0	// no problems 				
#define	FIFO_FULL	1	// FIFO full				
#define	FIFO_EMPTY	2	// FIFO empty				

/*-------------------------------------------------------------------------*\

								CLASS

\*-------------------------------------------------------------------------*/

class FifoData;

class Fifo {
	FifoData	*d;
public:
	Fifo(ushort size);
	~Fifo();
	int Write(word *buf, ushort size);
	int Read(word *buf, ushort size);
	void HowFull(ushort *words);
};

#endif	/* #ifndef __FIFO__	*/

