/*---------------------------------------------------------------------------*\

    FILE....: MAPDEV.CPP
    TYPE....: WIN32 C++ Function
    AUTHOR..: John Kostogiannis
    DATE....: 6/11/97

    Functions used to map the board and channel number to a handle and 
	vice versa.

\*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

	Copyright (C) 1999 Voicetronix Pty Ltd

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

\*---------------------------------------------------------------------------*/

#include <assert.h>
#include <stdlib.h>
#include <stdio.h>

#include "../wobbly/wobbly.h"
#include "../vpbapi/mapdev.h"
#include "../vpbapi/apifunc.h"

/*--------------------------------------------------------------------------*\

	FUNCTION.: mapdevtohndle
	AUTHOR...: John Kostogiannis
	DATE.....: 25/11/97

	Maps the board number and channel number to a handle, this function
	assumes four channels per board.

\*--------------------------------------------------------------------------*/

int mapdevtohndle(ushort brdnum, ushort chnum)
{  
    int hndle;
	
	assert(chnum < 8);


	if (model == VPB4) {
		hndle = brdnum<<2;
		hndle	+= chnum;
	} 
	else {
		hndle = brdnum<<3;
		hndle	+= chnum;
	}




	return(hndle);
}

/*--------------------------------------------------------------------------*\

	FUNCTION.: maphndletodev
	AUTHOR...: John Kostogiannis
	DATE.....: 25/11/97

	Maps the handle to board number and channel number.  This function
	assumes four channels per board.

\*--------------------------------------------------------------------------*/

void maphndletodev(int hndle,ushort *brdnum, ushort *chnum)
{  
	if (model == VPB4) {
		*brdnum = hndle & 0xfffc;
		*brdnum = *brdnum>>2;
		*chnum = hndle & 0x3;
	} 
	else {
		*brdnum = hndle & 0xfff8;
		*brdnum = *brdnum>>3;
		*chnum = hndle & 0x7;
	}
}