
/*---------------------------------------------------------------------------*\

    FILE....: VPBHANDLE.CPP
    TYPE....: C++ Function
    AUTHOR..: John Kostogiannis
    DATE....: 6/11/97

    Functions used to determine the device handle.

\*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

	Copyright (C) 1999 Voicetronix Pty Ltd

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

\*---------------------------------------------------------------------------*/

extern "C" {
#include <assert.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
}

#include "../vpbapi/vpbhandle.h"
#include "../wobbly/wobbly.h"
#include "../vpbreg/vpbreg.h"
#include "../vpbapi/mapdev.h"

/*-------------------------------------------------------------------------*\

							DEFINES

\*-------------------------------------------------------------------------*/

#define VPBHANDLE_FAIL		-1
#define VPBHANDLE_SUCCESS	0

/*-------------------------------------------------------------------------*\

							FUNCTION HEADERS

\*-------------------------------------------------------------------------*/

int split(char s[], char brdcomp[], char chncomp[]);

/*-------------------------------------------------------------------------*\

								FUNCTIONS
	
\*-------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*\

	FUNCTION.: VPBHandle()
	AUTHOR...: John Kostogiannis
	DATE.....: 24/11/97

    Functions used to determine the device handle given the Dialogic style
	board/channel specification string.

    NOTE: DR 4/2/98, this function assumes all of the boards have 4
	channels.

	NOTE: Modified by DR 26/5/98 to remove string support, direct entry of
	brd and ch number.

\*--------------------------------------------------------------------------*/

void VPBHandle(ushort brdnum, ushort chnum,int *handle, VPBREG *reg,ushort numbrds)
/*  char *devmane;	ptr to device name			*/
/*	int *handle;	ptr to channel handle		*/
/*	VPBREG	*reg;	ptr to regsitry info		*/
/*  ushort numbrds;	number of boards in system	*/
{
	VPBREG	*preg;
	
	preg = reg;
		
	if((brdnum>numbrds) || (brdnum < 1))
		throw Wobbly(VPBHANDLE_BOARD_NUMBER);
	
	preg = preg+brdnum-1;
	if((chnum>preg->numch) || (brdnum < 1))
		throw Wobbly(VPBHANDLE_CHANNEL_NUMBER);
	
	/* map board and channel number equivalent to driver number */

	brdnum -=1;
	chnum -=1;
	*handle = mapdevtohndle(brdnum,chnum);
}

/*--------------------------------------------------------------------------*\

	FUNCTION.: split
	AUTHOR...: John Kostogiannis
	DATE.....: 25/11/97

	Splits a string into left and right strings, where a "B" denotes
	the subsequent number as a board number and a "C" denotes it as a channel number.

\*--------------------------------------------------------------------------*/

int split(char s[], char brdcomp[], char chncomp[])
/*  char   s[];		input string					*/
/*  char   brdcomp[];	board number component		*/
/*  char   chncomp[];	channel number component	*/
{
    char	*bs;
	char	*cs;
    
		/* look for 'B' */

    bs = s;
    
	while((*bs != 'B') && (*bs != 0))
		bs++;
	
	bs +=1; 
    
	/* if no 'B' then return with no split */
	
    if (*bs == 0) {
		*brdcomp = 0;
		return(VPBHANDLE_FAIL) ;
    }
 
	/* look for 'C' */

    cs = s;
    
	while((*cs != 'C') && (*cs != 0))
		cs++;
	
	cs +=1; 
    
	/* if no 'C' then return with no split */
	 if (*cs == 0) {
		*chncomp = 0;
		return(VPBHANDLE_FAIL) ;
    }
    
	/* split into sub strings, one containing the board number,
	   the other the channel number */
	
	strncpy(brdcomp, bs, (cs-bs-1)); 
	*(brdcomp+(cs-bs-1)) = 0;
	strcpy(chncomp, cs);
	return(VPBHANDLE_SUCCESS);	
}


