/*---------------------------------------------------------------------------*\

    FILE....: ARBCH.H
    TYPE....: C Function Header File
    AUTHOR..: David Rowe
    DATE....: 17/3/98

    This module arbitrates the use of channels.  This is required because
	different threads may request the use of a given input or output channel
	at the same time.
	 
\*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

	Copyright (C) 1999 Voicetronix Pty Ltd

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

\*---------------------------------------------------------------------------*/

#ifndef __ARBCH__
#define __ARBCH__

void arbch_open(ushort numch);
void arbch_close(ushort numch);

void arbch_grab_play_channel(ushort handle);
int  arbch_keep_play_channel(ushort handle);
void arbch_release_play_channel(ushort handle);

void arbch_grab_record_channel(ushort handle);
int  arbch_keep_record_channel(ushort handle);
void arbch_release_record_channel(ushort handle);

#endif	/* #ifndef __ARBCH__	*/

