/*---------------------------------------------------------------------------*\

    FILE....: COMP.H
    TYPE....: C Function Header File
    AUTHOR..: David Rowe
    DATE....: 17/3/98

	Compression class packs and unpacks compressed speech between the DSP
	FIFOs which require one sample per 16 bit word, and the compressed
	format used by the PC which packs samples as tightly as possible.
	 
\*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

	Copyright (C) 1999 Voicetronix Pty Ltd

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

\*---------------------------------------------------------------------------*/

#ifndef __COMP__
#define __COMP__

#include "../contypes/contypes.h"

// The base class is pure virtual, a different derived class is implemented
// for each compression mode.  This class holds no data, we just use it
// as a covenient and extensible way to add compression modes.
//
// The bytes to words functions convert between the number of words the 
// DSP fifos require and the number of bytes required (given the 
// compression mode) to fill the buffer

class Compression {
public:
	virtual void pack(char *packedbytesout, word *wordsin, ushort nwordsin) = 0;
	virtual void unpack(word *wordsout, char *packedbytesin, ushort nbytesin) = 0;
	virtual ushort bytes2words(ushort nbytes) = 0;
	virtual ushort words2bytes(ushort nwords) = 0;
};

class PCMCompression : public Compression {
public:
	void pack(char *packedbytesout, word *wordsin, ushort nwordsin); 
	void unpack(word *wordsout, char *packedbytesin, ushort nbytesin);
	ushort bytes2words(ushort nbytes) { return nbytes; }
	ushort words2bytes(ushort nwords) { return nwords; }
};

class LinearCompression : public Compression {
public:
	void pack(char *packedbytesout, word *wordsin, ushort nwordsin); 
	void unpack(word *wordsout, char *packedbytesin, ushort nbytesin);
	ushort bytes2words(ushort nbytes) { return nbytes*sizeof(char)/sizeof(word); }
	ushort words2bytes(ushort nwords) { return nwords*sizeof(word)/sizeof(char); }
};

class ADPCMCompression : public Compression {
public:
	void pack(char *packedbytesout, word *wordsin, ushort nwordsin); 
	void unpack(word *wordsout, char *packedbytesin, ushort nbytesin);
	ushort bytes2words(ushort nbytes) { return nbytes*sizeof(word)/sizeof(char); }
	ushort words2bytes(ushort nwords) { return nwords*sizeof(char)/sizeof(word); }
};

#endif	/* #ifndef __COMP__	*/

