/*---------------------------------------------------------------------------*\

    FILE....: OBJTRACK.H
    TYPE....: C++ Module header file
    AUTHOR..: David Rowe
    DATE....: 25/3/98

    This module maintains a database of the VPB configuration manager
	objects.  This database is used to determine a device handle 
	(channel) from an object and board, or vice versa.
	 
\*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

	Copyright (C) 1999 Voicetronix Pty Ltd

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

\*---------------------------------------------------------------------------*/

#include "../contypes/contypes.h"

#ifndef __OBJTRACK__
#define __OBJTRACK__

// object classes

#define	UPOBJ	0	// start object for up direction (rx) objects
#define	DNOBJ	1	// start object down direction (tx) objects
#define	DTMFOBJ	2	// DTMF dectector object
#define	CPOBJ	3	// call progress (tone detector) object
#define	TONEOBJ	4	// tone generator objects
#define ADCOBJ	5	// ADC object (logging card)
#define AGCOBJ	6	// AGC object (logging card)
#define VOXOBJ	7	// VOX object (logging card)
#define ECHOOBJ	8	// Echo canceller object
#define DELAYOBJ 9	// Delay object
#define	FIFOUPOBJ 10	// FIFO Up object
#define	FIFODNOBJ 11	// FIFO Down object
	
// module functions

void objtrack_open();
void objtrack_close();
void objtrack_add_object(ushort cls, ushort id, ushort handle, ushort b);
int objtrack_id_to_handle(ushort cls, ushort id, ushort b);
int objtrack_handle_to_id(ushort cls, ushort handle);

#endif	// __OBJTRACK__
