/*---------------------------------------------------------------------------*\

    FILE....: VPBREGLINUX.CPP
    TYPE....: C++ Functions
    AUTHOR..: David Rowe
    DATE....: 12/9/99

    Sets up the configuration database known as the DSP registry.  In the
	NT bersion this was read from the Windows NT Registry.  Here it is
	just hard coded at compile time.  Future work could store this info
	in a text file.

\*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

	Copyright (C) 1999 Voicetronix Pty Ltd

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

\*---------------------------------------------------------------------------*/

#include <assert.h>
#include <stdlib.h>
#include <malloc.h>
#include <stdio.h>
#include <ctype.h>
#include <string.h>

#include "../wobbly/wobbly.h"
#include "../vpbreg/vpbreg.h"
#include "../message/mess.h"
#include "../vpbapi/vpbapi.h"
#include "../vpbapi/apifunc.h"

// Compile-time constants --------------------------------------------

#define	NUM_CARDS		1				// number of VPBs in this PC
#define	BASE_ADDRESS	0x310			// base address of VPB
#define	NUM_CHANNELS	4				// number of channels in VPB
#define	SIZE_MESS_Q		128				// size of message FIFOs (16-bit words)
#define	SIZE_RX_Q		1000			// size of Rx (up) signal FIFOs
#define	SIZE_TX_Q		1000			// size of Tx (down) signal FIFOs
#define	LENGTH_FRAME	160				// samples in each processing frame
#define	MODEL_NUM		0				// 0: VPB4
										// 1: VPB8L
#define	DD_MODEL		0				// 0: port I/O only device driver
										// 1: relay FIFO device driver
#define	SIZE_RELAY_BUF	16000			// size of relay buffer in device driver

// path and name of firmware file
#ifdef WIN32
#define	FIRMWARE_FILE	"k:\\vpb\\vpbmain.out"	
#else
#define	FIRMWARE_FILE	"/etc/vpb/vpbmain.out"	
#endif

/*-------------------------------------------------------------------------*\

			   FUNCTION HEADERS

\*-------------------------------------------------------------------------*/


/*-------------------------------------------------------------------------*\

			      CLASS

\*-------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*\

	FUNCTION.: ~VPBRegister
	AUTHOR...: John Kostogiannis
	DATE.....: 18/11/97

	Closes the VPB registry.

\*--------------------------------------------------------------------------*/

VPBRegister::~VPBRegister(){
	
	// free allocated VPB registry memory 

	assert(reg != NULL);
    free(reg);
}

/*--------------------------------------------------------------------------*\

	FUNCTION.: VPBRegister
	AUTHOR...: David Rowe
	DATE.....: 12/9/99

	Creates the VPB registry using compile-time constants.

\*--------------------------------------------------------------------------*/

VPBRegister::VPBRegister(ushort *num)
//  ushort *num;    number of VPBs											
{
   
	VPBREG *preg;			// ptr to current VPB registry (one per VPB card)
    ushort    j;
	
	// determine operating system

	mprintf("\nLinux\n");

	// validate arguments 

    assert(num != NULL);
	
	// hard code number of cards
	*num = NUM_CARDS;
	
	// check if any devices detected 
	if(*num == 0)
		throw Wobbly(VPBREG_NO_VPB_DEVICES_DETECTED);
	
	// check if more than max devices have been detected 	
	if(*num>MAX_VPB)
		throw Wobbly(VPBREG_TOO_MANY_VPBS_ACCESSED);

	// Allocate memory for VPB DSP registry
	if(((reg) = (VPBREG*)malloc(sizeof(VPBREG)*(*num)))==NULL)
		throw Wobbly(VPBREG_CANT_ALLOCATE_MEMORY);

	// hard code VPB Reg info
	preg = reg;
	preg->base = BASE_ADDRESS;
	preg->numch = NUM_CHANNELS;
	preg->szmess = SIZE_MESS_Q;
	for(j=0; j<preg->numch; j++) {
		preg->szrxdf[j] = SIZE_RX_Q;
		preg->sztxdf[j] = SIZE_RX_Q;
	}
	preg->lsf = LENGTH_FRAME;
	preg->model = MODEL_NUM;
	preg->ddmodel = DD_MODEL;
	preg->szRelayBuf = SIZE_RELAY_BUF;

	// init ptrs to PC copy of FIFO state variables
	preg->dnmess = NULL;		
	preg->upmess = NULL;			
	for(j=0; j<MAXCH; j++) {
		preg->rxdf[j] = NULL;		
		preg->txdf[j] = NULL;		
	}

	// set up firmware path and file name
	strcpy(preg->firm, FIRMWARE_FILE);

}

void vpbreg_load_default_tones(int numch)
{
}

