/*---------------------------------------------------------------------------*\

    FILE....: WOBBLY.H
    TYPE....: C++ Header
    AUTHOR..: David Rowe
    DATE....: 14/11/97

    Exception class used to terminate functions and returns error code to
    to level function with catch statement.

\*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

	Copyright (C) 1999 Voicetronix Pty Ltd

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

\*---------------------------------------------------------------------------*/

#ifndef __WOBBLY__
#define __WOBBLY__

#include "../contypes/contypes.h"

/*-------------------------------------------------------------------------*\

			       ERRROR CODES

\*-------------------------------------------------------------------------*/

// Conventions for error codes:
// 1. Prefix error code with module name.
// 2. Start codes for each module at multiples of 100 to allow room for
//    other errors from the same module.

#define PORT_ALREADY_INITIALISED									100
#define PORT_CANT_OPEN_DEVICE										101
#define PORT_CANT_CLOSE_DEVICE										102
#define PORT_WRITE_FAIL												103
#define PORT_READ_FAIL												104
#define PORT_ALLOCATE_FAIL											105
#define PORT_NEW_FAIL												106
#define	PORT_CANT_ALLOCATE_MEMORY									107

#define	VPBREG_REG_KEY_ACCESS_FAIL									200
#define	VPBREG_NO_VPB_DEVICES_DETECTED								201
#define VPBREG_TOO_MANY_VPBS_ACCESSED								202
#define VPBREG_REG_KEY_PROPERTY_FAIL								203
#define VPBREG_CANT_ALLOCATE_MEMORY									204
#define	VPBREG_CANT_GET_OS_VER										205
#define	VPBREG_OS_NOT_SUPPORTED										206

#define HIP_ALREADY_INITIALISED										300
#define HIP_CANT_ALLOCATE_MEMORY									301
#define HIP_CANT_GET_OS_VER											302
#define HIP_OS_NOT_SUPPORTED										303
#define	HIP_CANT_START_DEVICE_DRIVER								304
#define	HIP_OPEN_FAIL												305
#define	HIP_INIT_VPB_FAIL											306
#define	HIP_DSP_RESET_FAIL											307
#define	HIP_DSP_RUN_FAIL											308
#define	HIP_WRITE_DSP_SRAM_FAIL										309
#define	HIP_READ_DSP_SRAM_FAIL										310
#define	HIP_SET_PIP_FAIL											311
#define	HIP_CLOSE_FAIL												312

#define FIFO_CANT_ALLOCATE_MEMORY									400

#define COFF_CANT_OPEN_FILE											500
#define COFF_BAD_MAGIC_NUMBER										501
#define COFF_TOO_MANY_SECTIONS										502
#define COFF_INVALID_COFF_FILE										503
#define COFF_CANT_ALLOCATE_MEMORY									504
#define COFF_FILE_READ_ERROR										505
#define	COFF_DSP_MEMORY_TEST_FAILED									506
#define	COFF_CANT_FIND_SYMBOL										507

#define COMM_ALREADY_INITIALISED									600
#define	COMM_TIME_OUT_CONFIGURING_DSP								601
#define	COMM_DSP_MESSAGE_CORRUPT									602
#define	COMM_CANT_ALLOCATE_MEMORY									603
#define	COMM_TIME_OUT_WAITING_FOR_MESS								604
#define COMM_DSP_ASSERT												605
#define COMM_DOWN_MESSAGE_Q_FULL									606
#define	COMM_FIRMWARE_MODEL_NUMBER									607

#define	DSPFIFO_CANT_ALLOCATE_MEMORY								700
#define	DSPFIFO_OPEN_FAIL											701
#define	DSPFIFO_CLOSE_FAIL											702
#define	DSPFIFO_WRITE_FAIL											703
#define	DSPFIFO_READ_FAIL											704
#define	DSPFIFO_HOW_FULL_FAIL										705

#define	VPBHANDLE_DEVICENAME_FAIL									800
#define	VPBHANDLE_BOARD_NUMBER										801
#define VPBHANDLE_CHANNEL_NUMBER									802

#define MESS_CANT_CREATE_MESSAGEBOX									900

// API internal errors -------------------------------------------------

#define	VPBAPI_STARTMONMESSQUE_CANT_CREATE							1011
#define	VPBAPI_KILLMONMESSQUE_ERROR									1012

// file access functions

#define VPBAPI_FILEOPEN_CANT_WRITE_TO_READ_ONLY_FILE				1060
#define VPBAPI_FILEOPEN_FILENAME_ALREADY_EXISTS						1061
#define VPBAPI_FILEOPEN_INVALID_ARGUMENT							1062
#define VPBAPI_FILEOPEN_TOO_MANY_OPEN_FILES							1063
#define VPBAPI_FILEOPEN_FILE_OR_PATH_NOT_FOUND						1064
#define VPBAPI_FILEOPEN_CANT_CREATE_FILEHANDLE						1065
#define VPBAPI_FILECLOSE_INVALID_FILEHANDLE							1066
#define VPBAPI_FILESEEK_INVALID_FILEHANDLE							1067
#define VPBAPI_FILESEEK_INVALID_ARGUMENT							1068
#define VPBAPI_FILESEEK_CANT_MOVE_POINTER_TO_SPECIFIED_LOCATION		1069
#define VPBAPI_FILEREAD_INVALID_FILEHANDLE							1070
#define VPBAPI_FILEREAD_CANT_READ_FILE								1071
#define VPBAPI_FILEWRITE_INVALID_FILEHANDLE							1072
#define VPBAPI_FILEWRITE_NOT_ENOUGH_MEMORY_SPACE					1073
#define VPBAPI_FILEWRITE_CANT_WRITE_TO_FILE							1074

#define	ARBCH_PLAY_CHANNEL_IN_USE									1400
#define	ARBCH_RECORD_CHANNEL_IN_USE									1401

// API external errors -------------------------------------------------

#include "../vpbapi/vpberr.h"

// udp, programmable network errors in udp.cpp

#define	UDP_OUT_OF_MEMORY											1900
#define	UDP_WSASTARTUP_ERROR										1901
#define UDP_SOCKET_ERROR											1902	
#define UDP_BIND_ERROR												1903
#define UDP_SEND_ERROR												1904
#define UDP_RECEIVE_ERROR											1905
#define UDP_RECEIVE_IPADDR_ERROR									1906

// wave, programmable comm errors in wave.cpp

#define	WAVE_INITIALISE_ERROR										2000
#define	WAVE_BUFFERA_ERROR											2001
#define	WAVE_BUFFERB_ERROR											2002
#define	WAVE_CANT_PLAY_FORMAT										2003
#define	WAVE_FAIL_TO_OPEN											2004
#define	WAVE_UNABLE_TO_PREPARE_HEADER								2005	
#define	WAVE_UNABLE_TO_WRITE										2006	

#define	ADPCM_OUT_OF_MEMORY											2100

/*-------------------------------------------------------------------------*\

								CLASS

\*-------------------------------------------------------------------------*/

class Wobbly {
public:
    int	   code;			// error code defined above
	int    extended_code;	// optional additional info, eg IOCTL return code
	char   file[MAX_STR];	// file where wobbly occcured
	int    line;			// line where wobbly occurred

	Wobbly(const int c);
	Wobbly(const int c, const char file[], const int line);
	Wobbly(const int c, const int extended_c);
	void Wobbly::translate(char s[]);
};
#endif	// #ifndef __WOBBLY__


// if following macro is defined, we save file and line no. info
// to wobbly object.  Make sure this macro stays outside of __WOBBLY__
// block above.

#ifdef _DEBUG
#ifndef Wobbly
#define	Wobbly(x)	Wobbly(x, __FILE__, __LINE__);
#endif
#endif

