%define _release 1
%define _version 0.1.0

Summary: apennine - xmlrpc server of gnucomm services.
Name: apennine
Version: %{_version}
Release: %{_release}
Group: Communications
Source: ftp://bayonne.myip.org/pub/apennine/apennine-%{PACKAGE_VERSION}.tar.gz
Prefix: %{_prefix}
Vendor: Open Source Telecom
Copyright: GPL
BuildRoot: %{_tmppath}/apennine-root
Packager: David Sugar <dyfet@ostel.com>
BuildRequires: xmlrpc-c

%description
Apennine is a DSO based httpd server for providing XMLRPC access to 
various telephony services hosted as part of the GNU Telephony effort 
(gnucomm).  Apennine makes it possible to access and control 
gnucomm telephony server resources, such as Bayonne, thru XMLRPC.

%prep
rm -rf $RPM_BUILD_ROOT

%setup

./configure --prefix=%{_prefix}

%build
uname -a|grep SMP && make -j 2 || make

%install
mkdir -p $RPM_BUILD_ROOT/etc/logrotate.d
mkdir -p $RPM_BUILD_ROOT/etc/rc.d/init.d
mkdir -p $RPM_BUILD_ROOT/%{_libdir}/apennine
mkdir -p $RPM_BUILD_ROOT/%{_prefix}/sbin
make prefix=$RPM_BUILD_ROOT/%{_prefix} etc_prefix=$RPM_BUILD_ROOT/etc \
	mandir=$RPM_BUILD_ROOT/%{_mandir} etc_suffix="" install
#make prefix=$RPM_BUILD_ROOT/%{_prefix} \
#	mandir=$RPM_BUILD_ROOT/%{_mandir} man

%files
%defattr(-,root,root)
%doc AUTHORS COPYING NEWS README ChangeLog 
%config /etc/apennine.conf
/etc/rc.d/init.d/apennine
/etc/logrotate.d/apennine
%{_libdir}/apennine
%{_prefix}/include/xmlrpc_apennine.h
%{_prefix}/sbin/apennine

%clean
rm -rf $RPM_BUILD_ROOT

%pre
grep '^bayonne:' /etc/passwd >/dev/null || /usr/sbin/adduser -r bayonne

%post
/sbin/chkconfig apennine reset

%preun
/etc/rc.d/init.d/apennine stop
/sbin/chkconfig --level 0123456 apennine off

