dnl Copyright (C) 2001 Open Source Telecom Corporation.
dnl  
dnl This program is free software; you can redistribute it and/or modify
dnl it under the terms of the GNU General Public License as published by
dnl the Free Software Foundation; either version 2 of the License, or
dnl (at your option) any later version.
dnl 
dnl This program is distributed in the hope that it will be useful,
dnl but WITHOUT ANY WARRANTY; without even the implied warranty of
dnl MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
dnl GNU General Public License for more details.
dnl 
dnl You should have received a copy of the GNU General Public License
dnl along with this program; if not, write to the Free Software 
dnl Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
dnl 
dnl As a special exception to the GNU General Public License, if you 
dnl distribute this file as part of a program that contains a configuration 
dnl script generated by Autoconf, you may include it under the same 
dnl distribution terms that you use for the rest of that program.

AC_DEFUN(OST_XMLRPC_CONFIG,[
	ost_cv_xmlrpc=no
	AC_PATH_PROG(XMLRPC_CONFIG, xmlrpc-c-config, no)
	AC_SUBST(XMLRPC_CONFIG)
	if test "$XMLRPC_CONFIG" != "no" ; then
		ost_cv_xmlrpc=yes
	fi
])

AC_DEFUN(OST_XMLRPC_CLIENT,[
	AC_REQUIRE([OST_XMLRPC_CONFIG])
	XMLRPC_CLIENT_LIBS=""
	XMLRPC_CLIENT_FLAGS=""

	AC_MSG_CHECKING(for xmlrpc client)
	if test "$XMLRPC_CONFIG" != "no" ; then
		XMLRPC_CLIENT_LIBS=`$XMLRPC_CONFIG libwww-client --libs`
		XMLRPC_CLIENT_FLAGS=`$XMLRPC_CONFIG libwww-client  --cflags`
		AC_MSG_RESULT(yes)
	else
		AC_MSG_RESULT(no)
	fi
	AC_SUBST(XMLRPC_CLIENT_LIBS)
	AC_SUBST(XMLRPC_CLIENT_FLAGS)
])

AC_DEFUN(OST_XMLRPC_SERVER,[
	AC_REQUIRE([OST_XMLRPC_CONFIG])
	XMLRPC_SERVER_LIBS=""
	XMLRPC_SERVER_FLAGS=""

	AC_MSG_CHECKING(for xmlrpc server)
	if test "$XMLRPC_CONFIG" != "no" ; then
		XMLRPC_SERVER_LIBS=`$XMLRPC_CONFIG abyss-server --libs`
		XMLRPC_SERVER_FLAGS=`$XMLRPC_CONFIG abyss-server --cflags`
		AC_MSG_RESULT(yes)
	else
		AC_MSG_RESULT(no)
	fi
	AC_SUBST(XMLRPC_SERVER_LIBS)
	AC_SUBST(XMLRPC_SERVER_FLAGS)
])


AC_DEFUN(OST_XMLRPC_CGI,[
	AC_REQUIRE([OST_XMLRPC_CONFIG])
	XMLRPC_CGI_LIBS=""
	XMLRPC_CGI_FLAGS=""
	XMLRPC_CGI_PREFIX="none"

	AC_MSG_CHECKING(for xmlrpc cgi)
	if test "$XMLRPC_CONFIG" != "no" ; then
		if test -d /var/www ; then
			XMLRPC_CGI_PREFIX="/var/www/rpc"
		elif test -d /home/httpd ; then
			XMLRPC_CGI_PREFIX="/home/httpd/rpc"
		fi
	fi
	if test "$XMLRPC_CGI_PREFIX" != "none" ; then
		XMLRPC_CGI_LIBS=`$XMLRPC_CONFIG cgi-server --libs`
		XMLRPC_CGI_FLAGS=`$XMLRPC_CONFIG cgi-server --cflags`
		AC_MSG_RESULT([$XMLRPC_CGI_PREFIX])
		if test ! -d "$XMLRPC_CGI_PREFIX" ; then
			echo "warning  *** add this directory to your web server config!"
		fi
	else
		AC_MSG_RESULT(none)
	fi
	AC_SUBST(XMLRPC_CGI_LIBS)
	AC_SUBST(XMLRPC_CGI_FLAGS)
	AC_SUBST(XMLRPC_CGI_PREFIX)
])
