/* Copyright (C) 2001 Open Source Telecom Corporation.
 *  
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software 
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */ 

#include "server.h"
#include <fcntl.h>

static	int	fifo = -1;

static xmlrpc_value *bayonne_protocol(xmlrpc_env *env, xmlrpc_value *args, void  *user)
{
	char *auth;

	xmlrpc_parse_value(env, args, "(s)", &auth);
	if(env->fault_occurred)
		return NULL;

	if(apennine_auth(auth))
		return NULL;

	return xmlrpc_build_value(env, "(s)", "1");
}

static void getargs(char *string, char *out)
{
	char *tok = strtok(string, " &\t\n");
	
	while(tok)
	{
		*(out++) = '&';
		strcpy(out, tok);
		out += strlen(tok);
		tok = strtok(NULL, " \t\n");
	}
	*(out++) = '\n';
	*out = 0;
}

static xmlrpc_value *bayonne_hangupline(xmlrpc_env *env, xmlrpc_value *args,  void *user)
{
	char cmdbuf[512];
	char *auth;
	xmlrpc_int32 port;
	xmlrpc_int32 result = 0;

	xmlrpc_parse_value(env, args, "(si)", &auth, &port);
	if(env->fault_occurred)
		return NULL;

	if(apennine_auth(auth))
		return NULL;

	if(fifo > -1)
	{
		sprintf(cmdbuf, "hangup&%d\n", port);
		if(write(fifo, cmdbuf, strlen(cmdbuf)) < 1)
			result = -1;		
	}
	else
		result = -1;

	return xmlrpc_build_value(env, "(i)", result);
}

static xmlrpc_value *bayonne_busyline(xmlrpc_env *env, xmlrpc_value *args,  void *user)
{
	char cmdbuf[512];
	char *auth;
	xmlrpc_int32 port;
	xmlrpc_int32 result = 0;

	xmlrpc_parse_value(env, args, "(si)", &auth, &port);
	if(env->fault_occurred)
		return NULL;

	if(apennine_auth(auth))
		return NULL;

	if(fifo > -1)
	{
		sprintf(cmdbuf, "busy&%d\n", port);
		if(write(fifo, cmdbuf, strlen(cmdbuf)) < 1)
			result = -1;		
	}
	else
		result = -1;

	return xmlrpc_build_value(env, "(i)", result);
}

static xmlrpc_value *bayonne_idleline(xmlrpc_env *env, xmlrpc_value *args,  void *user)
{
	char cmdbuf[512];
	char *auth;
	xmlrpc_int32 port;
	xmlrpc_int32 result = 0;

	xmlrpc_parse_value(env, args, "(si)", &auth, &port);
	if(env->fault_occurred)
		return NULL;

	if(apennine_auth(auth))
		return NULL;

	if(fifo > -1)
	{
		sprintf(cmdbuf, "idle&%d\n", port);
		if(write(fifo, cmdbuf, strlen(cmdbuf)) < 1)
			result = -1;		
	}
	else
		result = -1;

	return xmlrpc_build_value(env, "(i)", result);
}

static xmlrpc_value *bayonne_hangupgroup(xmlrpc_env *env, xmlrpc_value *args,  void *user)
{
	char cmdbuf[512];
	char *auth, *grp;
	xmlrpc_int32 result = 0;

	xmlrpc_parse_value(env, args, "(ss)", &auth, &grp);
	if(env->fault_occurred)
		return NULL;

	if(apennine_auth(auth))
		return NULL;

	if(fifo > -1)
	{
		sprintf(cmdbuf, "hangup&%s\n", grp);
		if(write(fifo, cmdbuf, strlen(cmdbuf)) < 1)
			result = -1;	
	}
	else
		result = -1;	

	return xmlrpc_build_value(env, "(i)", result);
}

static xmlrpc_value *bayonne_busygroup(xmlrpc_env *env, xmlrpc_value *args,  void *user)
{
	char cmdbuf[512];
	char *auth, *grp;
	xmlrpc_int32 result = 0;

	xmlrpc_parse_value(env, args, "(ss)", &auth, &grp);
	if(env->fault_occurred)
		return NULL;

	if(apennine_auth(auth))
		return NULL;

	if(fifo > -1)
	{
		sprintf(cmdbuf, "busy&%s\n", grp);
		if(write(fifo, cmdbuf, strlen(cmdbuf)) < 1)
			result = -1;	
	}
	else
		result = -1;	

	return xmlrpc_build_value(env, "(i)", result);
}

static xmlrpc_value *bayonne_idlegroup(xmlrpc_env *env, xmlrpc_value *args,  void *user)
{
	char cmdbuf[512];
	char *auth, *grp;
	xmlrpc_int32 result = 0;

	xmlrpc_parse_value(env, args, "(ss)", &auth, &grp);
	if(env->fault_occurred)
		return NULL;

	if(apennine_auth(auth))
		return NULL;

	if(fifo > -1)
	{
		sprintf(cmdbuf, "idle&%s\n", grp);
		if(write(fifo, cmdbuf, strlen(cmdbuf)) < 1)
			result = -1;		
	}
	else
		result = -1;

	return xmlrpc_build_value(env, "(i)", result);
}


static xmlrpc_value *bayonne_schedule(xmlrpc_env *env, xmlrpc_value *args,  void *user)
{
	char cmdbuf[512];
	char *auth, *sched;
	xmlrpc_int32 result = 0;

	xmlrpc_parse_value(env, args, "(ss)", &auth, &sched);
	if(env->fault_occurred)
		return NULL;

	if(apennine_auth(auth))
		return NULL;

	if(fifo > -1)
	{
		sprintf(cmdbuf, "schedule&%s\n", sched);
		if(write(fifo, cmdbuf, strlen(cmdbuf)) < 1)
			result = -1;		
	}
	else
		result = -1;

	return xmlrpc_build_value(env, "(i)", result);
}



static xmlrpc_value *bayonne_ring(xmlrpc_env *env, xmlrpc_value *args,  void *user)
{
	char cmdbuf[512];
	char *auth, *cmd;
	xmlrpc_int32 port;
	xmlrpc_int32 result = 0;

	xmlrpc_parse_value(env, args, "(sis)", &auth, &port, &cmd);
	if(env->fault_occurred)
		return NULL;

	if(apennine_auth(auth))
		return NULL;

	if(fifo > -1)
	{
		sprintf(cmdbuf, "ring&%d", port);
		getargs(cmd, cmdbuf + strlen(cmdbuf));
		if(write(fifo, cmdbuf, strlen(cmdbuf)) < 1)
			result = -1;		
	}
	else
		result = -1;

	return xmlrpc_build_value(env, "(i)", result);
}

static xmlrpc_value *bayonne_startline(xmlrpc_env *env, xmlrpc_value *args,  void *user)
{
	char cmdbuf[512];
	char *auth, *cmd;
	xmlrpc_int32 port;
	xmlrpc_int32 result = 0;

	xmlrpc_parse_value(env, args, "(sis)", &auth, &port, &cmd);
	if(env->fault_occurred)
		return NULL;

	if(apennine_auth(auth))
		return NULL;

	if(fifo > -1)
	{
		sprintf(cmdbuf, "start&%d", port);
		getargs(cmd, cmdbuf + strlen(cmdbuf));
		if(write(fifo, cmdbuf, strlen(cmdbuf)) < 1)
			result = -1;		
	}
	else
		result = -1;

	return xmlrpc_build_value(env, "(i)", result);
}

static xmlrpc_value *bayonne_startgroup(xmlrpc_env *env, xmlrpc_value *args,  void *user)
{
	char cmdbuf[512];
	char *auth, *cmd, *grp;
	xmlrpc_int32 result = 0;

	xmlrpc_parse_value(env, args, "(sss)", &auth, &grp, &cmd);
	if(env->fault_occurred)
		return NULL;

	if(apennine_auth(auth))
		return NULL;

	if(fifo > -1)
	{
		sprintf(cmdbuf, "start&%s", grp);
		getargs(cmd, cmdbuf + strlen(cmdbuf));
		if(write(fifo, cmdbuf, strlen(cmdbuf)) < 1)
			result = -1;		
	}
	else
		result = -1;

	return xmlrpc_build_value(env, "(i)", result);
}

static xmlrpc_value *bayonne_submit(xmlrpc_env *env, xmlrpc_value *args,  void *user)
{
	char cmdbuf[512];
	char *auth, *cmd;
	xmlrpc_int32 port;
	xmlrpc_int32 result = 0;

	xmlrpc_parse_value(env, args, "(sis)", &auth, &port, &cmd);
	if(env->fault_occurred)
		return NULL;

	if(apennine_auth(auth))
		return NULL;

	if(fifo > -1)
	{
		sprintf(cmdbuf, "submit&%d", port);
		getargs(cmd, cmdbuf + strlen(cmdbuf));
		if(write(fifo, cmdbuf, strlen(cmdbuf)) < 1)
			result = -1;		
	}
	else
		result = -1;

	return xmlrpc_build_value(env, "(i)", result);
}

static xmlrpc_value *bayonne_redirect(xmlrpc_env *env, xmlrpc_value *args,  void *user)
{
	char cmdbuf[512];
	char *auth, *cmd;
	xmlrpc_int32 port;
	xmlrpc_int32 result = 0;

	xmlrpc_parse_value(env, args, "(sis)", &auth, &port, &cmd);
	if(env->fault_occurred)
		return NULL;

	if(apennine_auth(auth))
		return NULL;

	if(fifo > -1)
	{
		sprintf(cmdbuf, "redirect&%d", port);
		getargs(cmd, cmdbuf + strlen(cmdbuf));
		if(write(fifo, cmdbuf, strlen(cmdbuf)) < 1)
			result = -1;		
	}
	else
		result = -1;

	return xmlrpc_build_value(env, "(i)", result);
}
static xmlrpc_value *bayonne_request(xmlrpc_env *env, xmlrpc_value *args,  void *user)
{
	char cmdbuf[512];
	char *auth, *cmd, *grp;
	xmlrpc_int32 timeout;
	xmlrpc_int32 result = 0;

	xmlrpc_parse_value(env, args, "(sssi)", &auth, &grp, &cmd, &timeout);
	if(env->fault_occurred)
		return NULL;

	if(apennine_auth(auth))
		return NULL;

	if(fifo > -1)
	{
		sprintf(cmdbuf, "request&%s&%d", grp, timeout);
		getargs(cmd, cmdbuf + strlen(cmdbuf));
		if(write(fifo, cmdbuf, strlen(cmdbuf)) < 1)
			result = -1;		
	}
	else
		result = -1;

	return xmlrpc_build_value(env, "(i)", result);
}


static int bayonne_init(void)
{
	int count = 6;

	if(getuid() != 0)
	{
		if(access("/var/run/bayonne", R_OK))
			return 1;
	}

	while(count-- && fifo < 0)
	{
		sleep(10);
		fifo = open("/var/run/bayonne/bayonne.ctrl", O_RDWR);
		if(fifo < 0)
			fifo = open("/var/run/bayonne.ctrl", O_RDWR);
	}

	if(fifo < 0)
		return 1;
	return 0;
}

static void server_down(void)
{};

static apennine_method_t bayonne_methods[] = {
	{"ringline", &bayonne_ring},
	{"startline", &bayonne_startline},
	{"startgroup", &bayonne_startgroup},
	{"submitline", &bayonne_submit},
	{"redirectline", &bayonne_redirect},
	{"requestgroup", &bayonne_request},
	{"hangupline", &bayonne_hangupline},
	{"busyline", &bayonne_busyline},
	{"idleline", &bayonne_idleline},
	{"hangupgroup", &bayonne_hangupgroup},
	{"busygroup", &bayonne_busygroup},
	{"idlegroup", &bayonne_idlegroup},
	{"schedule", &bayonne_schedule},
	{"protocol", &bayonne_protocol}};

apennine_dso_t bayonne_dso = {
	NULL, NULL,
	"bayonne",
	&bayonne_init,
	&server_down,
	sizeof(bayonne_methods) / sizeof(apennine_method_t),
	bayonne_methods
};

