/* Copyright (C) 2001 Open Source Telecom Corporation.
 *  
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software 
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */ 

#include "server.h"

#ifdef  HAVE_DLFCN_H
#include <dlfcn.h>
 
#ifndef RTLD_GLOBAL
#define RTLD_GLOBAL     0
#endif
#endif

void loader(const char *path, const char *name)
{
	char namebuf[129];
	apennine_dso_t *scb;
	void *image;
	char *ext;
	
	snprintf(namebuf, 128, "%s/%s", path, name);
	image = dlopen(namebuf, RTLD_NOW | RTLD_GLOBAL);
	if(!image)
	{
		syslog(LOG_ERR, "%s: %s", name, dlerror());
		return;
	}

	scb = dlsym(image, "xmlrpc");
	if(!scb)
	{
		strcpy(namebuf, name);
		ext = strrchr(namebuf, '.');
		*ext = '_';
		scb = dlsym(image, namebuf);
	}
	if(!scb)
	{
		dlclose(image);
		syslog(LOG_ERR, "%s: no service block", name);
		return;
	}
	if(install(scb))
		dlclose(image);
}

int install(apennine_dso_t *dso)
{
	char *name;
	char namebuf[65];
	int count = dso->count;
	apennine_method_t *method = dso->methods;

	if((*dso->init)())
	{
		syslog(LOG_INFO, "%s: not installed", dso->name);
		return 1;
	}

	while(count--)
	{
		snprintf(namebuf, sizeof(namebuf) - 1, "%s.%s",
			dso->name, method->name); 		
		name = strdup(namebuf);
		xmlrpc_server_abyss_add_method(name, method->handler,  NULL);
		++method;
	}
	syslog(LOG_INFO, "%s: installed %d methods", dso->name,  dso->count);
	return 0;
}
	



















