/* Copyright (C) 2001 Open Source Telecom Corporation.
 *  
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software 
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */ 

#include "server.h"
#include <fcntl.h>

char	secret[33];

extern int apennine_auth(const char *authtag)
{
	/* other methods here... */

	/* final method old secret system if enabled. */

	if(!secret[0])
		return 1;

	if(strncmp(authtag, "secret:", 7)) 
		return 1;

	if(!strcmp(authtag, secret))
		return 0;
	return 1;
}

void getsecret(void)
{
	int fd;

	memset(secret, 0, 33);
	fd = open("/etc/apennine.secret", O_RDONLY);
	if(fd < 0)
		return;

	read(fd, secret, 32);
	close(fd);
}

void makesecret(void)
{
	int fd;

	memset(secret, 0, 33);

	fd = creat("/etc/apennine.secret", 0600);
	if(fd < 0)
		return;

	sprintf(secret, "secret:%08x%08x%08x", getpid(), time(), clock());
	write(fd, secret, 32);
	close(fd);
}

int main(int argc, char **argv)
{
	DIR *dir;
	const char *path = OBJPATH;
	char *config = "/etc/apennine.conf";
	const char *ext;
	struct dirent *dno;

	if(argc < 1 || argc > 2) 
	{
		fprintf(stderr, "Usage: apennine [apennine.conf]\n");
		exit(1);
    	}

	if(argv[1])
		config = argv[1];
	else
		config = "/etc/apennine.conf";

	if(access("/etc/apennine.secret", R_OK))
		makesecret();
	else
		getsecret();

	openlog("apenine", LOG_PERROR, LOG_DAEMON);
	if(access(config, R_OK))
	{
		syslog(LOG_CRIT, "%s: missing", config);
		exit(-1);
	}
	xmlrpc_server_abyss_init(XMLRPC_SERVER_ABYSS_NO_FLAGS, config);

	if(chdir(OBJPATH))
	{
		syslog(LOG_ERR, "%s: missing", OBJPATH);
		path = ".";
	}
	dir = opendir(path);

	while(dir)
	{
		dno = readdir(dir);
		if(!dno)
			break;
		ext = strrchr(dno->d_name, '.');
		if(!ext)
			continue;
		if(strcmp(ext, ".xmlrpc"))
		{
			if(strcmp(ext, ".dso"))
				continue;
		}
		loader(path, dno->d_name);
	}
	if(dir)
		closedir(dir);

	install(&server_dso);

	closelog();
	openlog("apenine", 0, LOG_DAEMON);
	syslog(LOG_DAEMON | LOG_INFO, "starting...");

	/* install default method handlers */

	xmlrpc_server_abyss_run();
	return 0;
}
