/* Copyright (C) 2001 Open Source Telecom Corporation.
 *  
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software 
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */ 

#ifndef	APENNINE_XMLRPC_H
#define	APENNINE_XMLRPC_H

/* common control structure for all DSO objects. */

typedef	struct _apenine_method
{
	const char *name;
	xmlrpc_value * (*handler)(xmlrpc_env *env, xmlrpc_value *args,  void *);
}	apennine_method_t;

typedef	struct _apennine_xmlscb
{
	struct _apennine_xmscb *prev, *next;
	const char *name;
	int (*init)(void);
	void (*down)(void);
	int	count;
	apennine_method_t *methods;
}	apennine_dso_t;

/* external token reference */
extern int apennine_auth(const char *token);
	
#endif

