/*---------------------------------------------------------------------------*\

    FILE....: COMM.H
    TYPE....: C Function Header File
    AUTHOR..: David Rowe
    DATE....: 2/10/97

    Functions used for PC to DSP communications, which includes passing
    messages to and from the DSP, and transfering information to and from
    FIFOs in the DSP.

\*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

	Copyright (C) 1999 Voicetronix Pty Ltd

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

\*---------------------------------------------------------------------------*/

#ifndef __COMM__
#define __COMM__

#include "contypes.h"
#include "vpbreg.h"
#include "messages.h"

/*-------------------------------------------------------------------------*\

			       DEFINES

\*-------------------------------------------------------------------------*/

// return codes for message functions below 

#define	OK		0
#define	COMM_MAX_MESS	128	// maximum message length from PC	  
#define	COMM_FULL	1	// write failed as DSP message queue full 
#define	COMM_EMPTY	2	// read failed as no messages		  

/*-------------------------------------------------------------------------*\

			    FUNCTION HEADERS

\*-------------------------------------------------------------------------*/

class CommData;

class Comm {
	CommData	*d;
public:
	Comm();
	~Comm();
	int PutMessageVPB(ushort board, word *mess);
	int GetMessageVPB(ushort board, word *mess);
	void WaitForMessageVPB(ushort board, word *mess, ushort mtype, 
			       ushort wait);
	VPBREG *vpbreg(ushort board);
	ushort Comm::numboards();
	Hip *hip(ushort board);
	void CheckForAssert(ushort board);
};

#endif	/* #ifndef __COMM__	*/

