/*--------------------------------------------------------------------------*\

    FILE....: TYPES.H
    TYPE....: C Function Header File
    AUTHOR..: David Rowe
    DATE....: 1/10/97

    Commonly used constants and typedefs.

\*--------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

	Copyright (C) 1999 Voicetronix Pty Ltd

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

\*---------------------------------------------------------------------------*/

#ifndef __CONTYPES__
#define __CONTYPES__

/*--------------------------------------------------------------------------*\

				DEFINES

\*--------------------------------------------------------------------------*/

/* used with assert to validate arguments */

#define	MAX_VPB		20	   /* maximum number of VPBs		*/
#define START_BASE	0x300	   /* lowest possible base addr	        */
#define	END_BASE	0x400	   /* highest possible base addr	*/
#define MAX_LENGTH	0x10000l   /* maximum length for 'C5x mem	*/
#define	MAX_STR		256	   /* maximum string size	      	*/

#define	LOW(x)		(((long)x)&0xffff)
#define	HIGH(x)		(((long)x)>>16)

/*--------------------------------------------------------------------------*\

				TYPEDEFS

\*--------------------------------------------------------------------------*/

typedef unsigned char byte;
typedef unsigned short ushort;
typedef unsigned short word;
typedef unsigned long ulong;

#endif	/* #ifndef __CONTYPES__	*/




