/*--------------------------------------------------------------------------*\

    FILE....: HIP.H
    TYPE....: C++ Module Header File
    AUTHOR..: David Rowe
    DATE....: 19/11/97

    VPB access functions that implement the PC side of the Host Intercace Port
    (HIP).

\*--------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

	Copyright (C) 1999 Voicetronix Pty Ltd

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

\*---------------------------------------------------------------------------*/

#ifndef __HIP__
#define __HIP__

#include "contypes.h"

/*--------------------------------------------------------------------------*\

				  CLASS

\*--------------------------------------------------------------------------*/

class baseHipData;

class Hip {
	baseHipData	*d;
public:
	Hip(int DeviceDriverModel);
	~Hip();
	void InitVpb(ushort base);
	void DspReset(ushort board);
	void DspRun(ushort board);
	void WriteDspSram(ushort board, ushort addr, ushort length, word *buf);
	void ReadDspSram(ushort board, ushort addr, ushort length, word *buf);
	void SetPip(ushort board, char enables);
	void *GethndFile();
	int  GetDeviceDriverModel();
};

#endif	/* #ifndef __HIP__	*/

