/*--------------------------------------------------------------------------*\

    FILE....: IOCTLINUX.CPP
    TYPE....: C Header File
    AUTHOR..: David Rowe
    DATE....: 22/9/99

    This file defines the interface between the Linux kernel mode 
    device driver and the user mode driver code.  This interface
    supports both ISA and PCI cards with the same kernel mode
    driver.
	
\*--------------------------------------------------------------------------*/

#ifndef __IOCTLLINUX__
#define __IOCTLLINUX__

typedef struct {
  unsigned short port;
  unsigned short *data;
  int            length;
  int	         dsp_addr;
  int            pci_num;
} VPB_DATA;

#define	VPB_IOC_MAGIC	'v'

// ISA commands

#define	VPB_IOC_ADD_BOARD	_IO(VPB_IOC_MAGIC, 1)
#define	VPB_IOC_REMOVE_BOARD	_IO(VPB_IOC_MAGIC, 2)
#define	VPB_IOC_BLOCK_WRITE	_IO(VPB_IOC_MAGIC, 3)
#define	VPB_IOC_BLOCK_READ	_IO(VPB_IOC_MAGIC, 4)

// PCI commands

#define VPB_IOC_PCI_BLOCK_WRITE _IO(VPB_IOC_MAGIC, 5)
#define VPB_IOC_PCI_BLOCK_READ  _IO(VPB_IOC_MAGIC, 6)
#define VPB_IOC_PCI_DSP_RESET   _IO(VPB_IOC_MAGIC, 7)
#define VPB_IOC_PCI_DSP_RUN     _IO(VPB_IOC_MAGIC, 8)

#endif

