#if 0
// Copyright (C) 2000 Open Source Telecom Corporation.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
#endif

#include "config.h"
#include "ioports.h"

#ifdef	HAVE_SYS_IO_H
#include <sys/io.h>
#else
#ifdef	HAVE_ASM_IO_H
#include <asm/io.h>
#endif
#endif

#include <assert.h>

#ifdef	__FreeBSD__
#include <machine/sysarch.h>
#endif

#ifndef	__alpha__

static __inline__ void _outb(int value, int port)
{
	__asm__ volatile ("outb %0,%1"
		::"a" ((unsigned char)value), "d"((unsigned short) port));
}

static __inline__ void _outw(int value, int port)
{
	__asm__ volatile ("outw %0,%1"
		::"a" ((unsigned short)value), "d"((unsigned short)port));
}

static __inline__ int _inb(int port)
{
	unsigned char value;
	__asm__ volatile ("inb %1,%0"
		:"=a" (value)
		:"d"((unsigned short) port));
	return value;
}

static __inline__ int _inw(int port)
{
	unsigned short value;
	__asm__ volatile ("inw %1,%0"
		:"=a" (value)
		:"d"((unsigned short) port));
	return value;
}

#endif

void ioread(unsigned port, unsigned short *addr, unsigned len)
{
	while(len--)
		*(addr++) = _inw(port);
}
	
void iowrite(unsigned port, unsigned short *addr, unsigned len)
{
	while(len--)
		_outw(*addr++, port);
}

void ioset(unsigned port, unsigned short value)
{
	if(port % 2)
		_outb(value, port);
	else
		_outw(value, port);
}

int iopriv(unsigned port, int flag)
{
	int ret;

#ifdef	__FreeBSD__
	if(flag) {
		ret = i386_set_ioperm(port,0x4,1);
		assert(ret == 0);
		return ret;
	}
	else {
		ret = i386_set_ioperm(port,0x4,0);
		assert(ret == 0);
		return ret;
	}
#else
	if(flag)
		iopl(3);
	else
		iopl(0);
#endif
}



