// Copyright (C) 2000 Open Source Telecom Corporation.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#include "config.h"
#include "ioports.h"

#define	MAX_LENGTH	0x100000
#define	MAX_SECT	20

#define	STYP_COPY	0x10
#define	STYP_TEXT	0x20
#define	STYP_DATA	0x40
#define	STYP_BSS	0x80

#define	F_MAGIC		0x92
#define	F_OPTHDR	0x1c

typedef	unsigned short	word;

#pragma pack(1)

typedef struct
{
	unsigned short f_magic;
	unsigned short f_nscns;
	long	f_timdat;
	long	f_symptr;
	long	f_nsyms;
	unsigned short f_opthdr;
	unsigned short f_flags;
} FILHEADER;

typedef struct
{
	short magic;
	short version;
	long exec_size;
	long init_size;
	long uninit_size;
	long entry;
	long start_code;
	long start_data;
} OPT_FILHEADER;	

typedef struct
{
	char	s_name[8];
	long	s_paddr;
	long	s_vaddr;
	long	s_size;
	long	s_scnptr;
	long	s_relptr;
	long	s_lnnoptr;
	unsigned short	s_nreloc;
	unsigned short	s_nlnno;
	unsigned short	flags;
	char	reserved;
	char	mem_page;
} SECTION_HEADER;

typedef struct
{
	char	n_name[8];
	long	n_value;
	unsigned short n_scnum;
	unsigned short n_type;
	char	n_class;
	char	n_numaux;
} SYMBOL_ENTRY;

#pragma pack()

bool VPBThread::dspLoader(const char *fname)
{
	int fd;
	FILHEADER	file_hdr;
	OPT_FILHEADER	opt_file_hdr;
	SECTION_HEADER	sect_hdr[MAX_SECT];
	int i;
	long s_paddr;
	long s_size;
	unsigned short flags;
	long num_read;
	unsigned short rec_size;
	long bss_addr;
	word *pw;
	int sections;

	fd = open(fname, O_RDONLY);
	if(fd < 0)
	{
		slog(SLOG_ERROR) << "vpb: " << fname << ": no access" << endl;
		return false;
	}

	read(fd, &file_hdr, sizeof(FILHEADER));
	if(file_hdr.f_magic != F_MAGIC)
	{
		slog(SLOG_ERROR) << "vpb: " << fname << ": invalid format" << endl;
		close(fd);
		return false;
	}

	if(file_hdr.f_opthdr == F_OPTHDR)
		read(fd, &opt_file_hdr, sizeof(OPT_FILHEADER));

	sections = file_hdr.f_nscns;
	if(sections >= MAX_SECT)
	{
		close(fd);
		return false;
	}

	for(i = 0; i < sections; ++i)
		read(fd, &sect_hdr[i], sizeof(SECTION_HEADER));

	for(i = 0; i < sections; ++i)
	{
		flags = sect_hdr[i].flags;
		s_paddr = sect_hdr[i].s_paddr;
		s_size = sect_hdr[i].s_size;

		if((s_paddr < 0) || (s_paddr >= MAX_LENGTH))
		{
			close(fd);
			return false;
		}
		if((s_size < 0) || (s_size >= MAX_LENGTH))
		{
			close(fd);
			return false;
		}
		if((s_paddr + s_size) > MAX_LENGTH)
		{
			close(fd);
			return false;
		}
		if(((flags == STYP_TEXT) || (flags == STYP_DATA)) && (s_size	!= 0))	
		{
			pw = new word[s_size];
			lseek(fd, sect_hdr[i].s_scnptr, SEEK_SET);
			read(fd, pw, sizeof(word) * s_size);
			dspWrite((unsigned short)s_paddr, pw, (unsigned short)s_size);
			delete pw;
		}	
		if((flags & STYP_COPY) && (flags & STYP_DATA))
		{
			lseek(fd, sect_hdr[i].s_scnptr, SEEK_SET);
			for(;;)
			{
				read(fd, &rec_size, sizeof(rec_size));
				if(!rec_size)
					break;

				bss_addr = 0;
				read(fd, &bss_addr, sizeof(bss_addr));
				pw = new word[rec_size];
				read(fd, pw, rec_size * sizeof(word));
				dspWrite((unsigned short)bss_addr, pw, rec_size);
 				delete pw;
			}
		}
	}
	close(fd);
	return true;
}

















