/*---------------------------------------------------------------------------*\

    FILE....: MESS.CPP
    TYPE....: C++ Function File
    AUTHOR..: John Kostogiannis
    DATE....: 20/11/97

    Interface functions for messages.  Messages are information sent by
    various modules to a message window just like printf to the console. 
	
\*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

	Copyright (C) 1999 Voicetronix Pty Ltd

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

\*---------------------------------------------------------------------------*/

#include "config.h"

#include <assert.h>
#include <stdlib.h>
#include <stdio.h>
#include <stdarg.h>

#include "mess.h"

/*-------------------------------------------------------------------------*\

				STATICS

\*-------------------------------------------------------------------------*/

static int enable = OFF;
static int file_enable;

static FILE *file;

/*-------------------------------------------------------------------------*\

			       FUNCTIONS

\*-------------------------------------------------------------------------*/

/*-------------------------------------------------------------------------*\

    FUNCTION.: mess_mprintf_on
    AUTHOR...: John Kostogiannis
    DATE.....: 20/11/97

    Enables mprintf statements.  Either this function of mprintf_off should
    be called during program initialisation to place the mprintf functions
    in a known state.

\*-------------------------------------------------------------------------*/

void mess_mprintf_on(void){
	enable = ON;
	file_enable = OFF;
}

/*-------------------------------------------------------------------------*\

    FUNCTION.: mess_mprintf_on(char *fn)
    AUTHOR...: John Kostogiannis
    DATE.....: 20/11/97

    This version logs messages to a text file rather than the console.

\*-------------------------------------------------------------------------*/

void mess_mprintf_on(char *fn){
	enable = ON;
	file_enable = ON;
	file = fopen(fn,"wt");
}

/*-------------------------------------------------------------------------*\

    FUNCTION.: mprintf_on
    AUTHOR...: John Kostogiannis
    DATE.....: 20/11/97

    This version logs messages to a text file rather than the console,
    useful for opening file for append rather than overwrite.

\*-------------------------------------------------------------------------*/

void mess_mprintf_on(char *fn, char *s){
	enable = ON;
	file_enable = ON;
	file = fopen(fn,s);
}


/*-------------------------------------------------------------------------*\

    FUNCTION.: mprintf_off
    AUTHOR...: John Kostogiannis
    DATE.....: 20/11/97

    Disables mprintf statements.  Either this function or mprintf_on should
    be called during program initialisation to place the mprintf functions
    in a known state.

\*-------------------------------------------------------------------------*/

void mess_mprintf_off(void)
{
	enable = OFF;
	if (file_enable == ON){
		file_enable = OFF;
		fclose(file);
	}
}
	

/*-------------------------------------------------------------------------*\

    FUNCTION.: mprintf
    AUTHOR...: John Kostogiannis
    DATE.....: 20/11/97

    Called by other functions to log messages.

\*-------------------------------------------------------------------------*/

void mprintf(char *fmt, ...)
{
	va_list argptr;

	if(enable) {
		va_start(argptr, fmt);
		vprintf(fmt, argptr);
		if(file_enable) {
			vfprintf(file,fmt,argptr);
		}
		va_end(argptr);
	}

}


