/*--------------------------------------------------------------------------*\

    FILE....: MTISA.CPP
    TYPE....: C++ Program
    AUTHOR..: David Rowe
    DATE....: 29/5/00

    User mode test program for Voicetronix VPB4 card.  This program can be
    used as a basic hardware test program, and is useful for determining
    if the I/O base address is set correctly.

    Run: './mtisa BASE' (e.g. './mtisa 0x300')

\*--------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

	Copyright (C) Voicetronix Pty Ltd

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

\*---------------------------------------------------------------------------*/

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>

#include "vpbapi.h"
#include "hip.h"

#define SIZE_WD 0x2

int main(int argc, char *argv[]) {
	int               i;
	unsigned short    bufwr[SIZE_WD];
	unsigned short    bufrd[SIZE_WD];
	int               base;

	if (argc != 2) {
		printf("usage: mtisa BASE\n");
		printf("e.g. 'mtisa 0x300'\n");
		exit(0);
	}

	// init
	sscanf(argv[1], "%x", &base);
	Hip h(3);

	// set up write block
	for(i=0; i<SIZE_WD; i++)
		bufwr[i] = i;

	// Place DSP in reset
	h.InitVpb(base);
	h.DspReset(0);

	// block write to DSP RAM
	h.WriteDspSram(0, 0x0, SIZE_WD, bufwr);

	// block read from DSP RAM
	h.ReadDspSram(0, 0x0, SIZE_WD, bufrd);

	// check read block is the same as write block
	for(i=0; i<SIZE_WD; i++) {
		if (bufwr[i] != bufrd[i]) {
			printf("FAILED - try another base address!\n");
			exit(1);
		}
	}

	printf("PASSED!\n");

	return 0;
}
