/*---------------------------------------------------------------------------*\

    FILE....: OBJTRACK.CPP
    TYPE....: C++ Module
    AUTHOR..: David Rowe
    DATE....: 25/3/98

    This module maintains a database of the VPB configuration manager
    objects.  This database is used to determine a device handle 
    (channel) from an object and board, or vice versa.
	 
\*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

	Copyright (C) 1999 Voicetronix Pty Ltd

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

\*---------------------------------------------------------------------------*/

#include "config.h"

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>

#include "objtrack.h"

/*---------------------------------------------------------------------------*\

				    DEFINES

\*--------------------------------------------------------------------------*/

typedef struct OBJS {
	ushort	cls;		// class of object
	ushort	id;		// id of object on this board
	ushort	handle;		// handle of channel
	ushort	b;		// board number
	struct	OBJS *next;	// next object in linked list	
} OBJ;

/*---------------------------------------------------------------------------*\

				    STATICS

\*--------------------------------------------------------------------------*/

static OBJ *start;		// first object in linked list
static OBJ *end;		// last object in linked list

/*---------------------------------------------------------------------------*\

			        FUNCTIONS

\*--------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

	FUNCTION: objtrack_open
	AUTHOR..: David Rowe
	DATE....: 25/3/98

	Initialises the objtrack module.

\*--------------------------------------------------------------------------*/

void objtrack_open() {
	start = NULL;	
	end = NULL;
}

/*---------------------------------------------------------------------------*\

	FUNCTION: objtrack_close
	AUTHOR..: David Rowe
	DATE....: 19/3/98

	Closes the playrec module.

\*--------------------------------------------------------------------------*/

void objtrack_close() {
	OBJ	*po = start;
	OBJ	*d;

	// delete all objects in linked list

	while(po != NULL) {
		d = po;
		po = po->next;
		delete d;
	}
		
}

/*---------------------------------------------------------------------------*\

	FUNCTION: objtrack_add_object()
	AUTHOR..: David Rowe
	DATE....: 25/3/98

	Adds a config manager object to the database.

\*--------------------------------------------------------------------------*/

void objtrack_add_object(ushort cls, ushort id, ushort handle, ushort b)
//	ushort	cls		class of object
//	ushort	id		id of object on this board
//	ushort	handle		handle of channel
//	ushort	b		board number
{
	OBJ		*po;

	po = new OBJ;
	po->cls = cls;
	po->id = id;
	po->handle = handle;
	po->b = b;
	po->id = id;
	po->next = NULL;

	// attach new object to end of list

	if (start == NULL) {
		start = end = po;
	}
	else {
		end->next = po;
		end = po;
	}
}

/*---------------------------------------------------------------------------*\

	FUNCTION: objtrack_handle_to_id()
	AUTHOR..: David Rowe
	DATE....: 25/3/98

	Finds the handle of an object given the id.

\*--------------------------------------------------------------------------*/

int objtrack_id_to_handle(ushort cls, ushort id, ushort b)
//	ushort	cls    class of object
//	ushort	id     id of object on this board
//	ushort	b      board number
{
	OBJ	*po = start;

	while(po != NULL) {
		if ((po->cls == cls) && (po->id == id) && (po->b == b))
			return(po->handle);
		po = po->next;
	}

	assert(0);
	return(0);
}

/*---------------------------------------------------------------------------*\

	FUNCTION: objtrack_handle_to_id()
	AUTHOR..: David Rowe
	DATE....: 25/3/98

	Finds the handle of an object given the class and channel handle.  If
	there is more than one object of this class on this channel this 
	function will only return the id of the first one found.

\*--------------------------------------------------------------------------*/

int objtrack_handle_to_id(ushort cls, ushort handle)
//	ushort	cls	class of object
//	ushort	handle	handle of channel
{
	OBJ	*po = start;

	while(po != NULL) {
		if ((po->cls == cls) && (po->handle == handle))
			return(po->id);
		po = po->next;
	}

	assert(0);
	return(0);
}



