/*---------------------------------------------------------------------------*\

    FILE....: PLAYREC.H
    TYPE....: C++ Module
    AUTHOR..: David Rowe
    DATE....: 10/2/98

    This module implements the play and record functions for the VPB API.
	 
\*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

	Copyright (C) 1999 Voicetronix Pty Ltd

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

\*---------------------------------------------------------------------------*/

#ifndef	__PLAYREC__
#define	__PLAYREC__

#include "contypes.h"

void playrec_open(ushort numch);
void playrec_close();

// "internal" versions of API functions

void play_file(int handle, char file_name[]);
void play_buf_finish(int handle);
int  play_buf_sync(int handle, char *buf, unsigned short length);
void play_buf_start(int handle, unsigned short mode);

void record_file(int handle, char file_name[], unsigned short mode);
void record_buf_finish(int handle);
int  record_buf_sync(int handle, char *buf, unsigned short length);
void record_buf_start(int handle, unsigned short mode);

// diagnostic helper

int playrec_underflow_valid(int handle);

// callback from MMQ

void playrec_fifo_disabled(int h);

#endif	// __PLAYREC__

