/*---------------------------------------------------------------------------*\

    FILE....: TIMER.C
    TYPE....: C++ Function
    AUTHOR..: John Kostogiannis
    DATE....: 14/11/97

    Functions used to implement timers used in the VPB driver.

\*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

	Copyright (C) 1999 Voicetronix Pty Ltd

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

\*---------------------------------------------------------------------------*/

#include "config.h"

#include <assert.h>
#include <stdlib.h>
#include <stdio.h>

#include "timer.h"
#include "generic.h"

/*-------------------------------------------------------------------------*\

				CLASS

\*-------------------------------------------------------------------------*/

class VPBTimer{
public:
	long start_time;
	long current_time;	
	ushort time_out;
	VPBTimer();
	~VPBTimer();
	void start();
	ushort check_time_out(ushort elapsed);
	ushort check_time_out_ms(ulong elapsedms);
};

/*-------------------------------------------------------------------------*\

			    INTERFACE MEMBER FUNCTIONS

\*-------------------------------------------------------------------------*/

Timer::Timer(){
	// create and initialise VBPTimer
	vpbtimer = new VPBTimer;
	assert(vpbtimer != NULL);
}

Timer::~Timer(){
	// delete VBPTimer
	delete vpbtimer;
}

void Timer::timer_start(){
	vpbtimer->start_time = GenerictimeGetTime();
}

void Timer::timer_check_time_out(ushort elapsed,ushort *timeout){
	*timeout = vpbtimer->check_time_out(elapsed);
}

void Timer::timer_check_time_out_ms(ulong elapsedms,ushort *timeout){
	*timeout = vpbtimer->check_time_out_ms(elapsedms);
}

/*--------------------------------------------------------------------------*\

	FUNCTION.: VPBTimer
	AUTHOR...: John Kostogiannis
	DATE.....: 13/11/97

	Initialises a timer for future time out checks. 

\*--------------------------------------------------------------------------*/

VPBTimer::VPBTimer(){
	time_out = 0;
	current_time = 0;
	start_time = 0;
}

VPBTimer::~VPBTimer(){}

/*--------------------------------------------------------------------------*\

	FUNCTION.: timer_check_time_out
	AUTHOR...: John Kostogiannis
	DATE.....: 3/10/97

	Checks if a specific amout of time has elapsed since a timer was
	created.

\*--------------------------------------------------------------------------*/

ushort VPBTimer::check_time_out(ushort elapsed)
{
	long elapsedmsec;		        /* time elapsed in msec	*/
	
	elapsedmsec = 1000*elapsed;
    
	current_time = GenerictimeGetTime();	/* stores current time */

	if (current_time > (start_time + elapsedmsec))
		return TIME_OUT;
	else
		return OK;
}

/*--------------------------------------------------------------------------*\

	FUNCTION.: timer_check_time_out_ms
	AUTHOR...: David Rowe
	DATE.....: 4/3/98

	As above but time specified in ms.

\*--------------------------------------------------------------------------*/

ushort VPBTimer::check_time_out_ms(ulong elapsedms)
{
	long elapsedmsec;		        /* time elapsed in msec	*/
	
	elapsedmsec = (long)elapsedms;
    
	current_time = GenerictimeGetTime();	/* stores current time */

	if (current_time > (start_time + elapsedmsec))
		return TIME_OUT;
	else
		return OK;
}
