/*---------------------------------------------------------------------------*\

    FILE....: TIMERCPP.H
    TYPE....: C Header File
    AUTHOR..: David Rowe
    DATE....: 3/10/97

    Functions used implement time out timers. 

\*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

	Copyright (C) 1999 Voicetronix Pty Ltd

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

\*---------------------------------------------------------------------------*/

#ifndef __TIMERCPP__
#define __TIMERCPP__

#include "contypes.h"

/*-------------------------------------------------------------------------*\

				DEFINES

\*-------------------------------------------------------------------------*/

#define	OK		0
#define	TIME_OUT	1

/*-------------------------------------------------------------------------*\

			         CLASS

\*-------------------------------------------------------------------------*/

class VPBTimer;

class Timer {
		VPBTimer  *vpbtimer;
public:
		Timer();
		~Timer();
		void timer_start();
		void timer_check_time_out(ushort elapsed, ushort *timeout);
		void timer_check_time_out_ms(ulong elapsedms, ushort *timeout);
};

#endif	/* #ifndef __TIMER__	*/

