/*---------------------------------------------------------------------------*\

    FILE....: TRANSEVT.CPP
    TYPE....: C Module
    AUTHOR..: David Rowe
    DATE....: 26/3/98

    The functions in this module translate events from the VPB API to
    meaningfull strings.  Useful for development.

\*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

	Copyright (C) 1999 Voicetronix Pty Ltd

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

\*---------------------------------------------------------------------------*/

#include "config.h"

#include <assert.h>
#include <string.h>
#include <stdio.h>

#include "vpbapi.h"

/*-------------------------------------------------------------------------*\
	
				 STATICS

\*-------------------------------------------------------------------------*/

static char *tonestr[] = {	 
	"Dial",
	"Ringback",
	"Busy",
	"Grunt"
};

/*-------------------------------------------------------------------------*\
	
				FUNCTIONS

\*-------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

	FUNCTION: vbp_translate_event
	AUTHOR..: David Rowe
	DATE....: 26/3/98

	Function to translate the current event into a string.

\*--------------------------------------------------------------------------*/

void vpb_translate_event(VPB_EVENT *e, char s[])
//	VPB_EVENT	e;	// input event to translate
//	char		s[];	// translated string, VPB_MAX_STR long
{

	switch(e->type) {
		
	case VPB_RING:
		sprintf(s, "[%02d] Ring\n",e->handle);
		break;

	case VPB_DIGIT:
		break;

	case VPB_TONEDETECT:
		if (e->data <= VPB_GRUNT)
			sprintf(s, "[%02d] Tone Detect: %s\n",e->handle,
				tonestr[e->data]);
		else
			sprintf(s, "[%02d] Tone Detect: %d\n",e->handle,
				e->data);
		break;

	case VPB_PLAYEND:
		sprintf(s, "[%02d] Play End\n",e->handle);
		break;

	case VPB_RECORDEND:
		sprintf(s, "[%02d] Record End\n",e->handle);
		break;
		
	case VPB_DIALEND:
		sprintf(s, "[%02d] Dial End\n",e->handle);
		break;
		
	case VPB_TIMEREXP:
		sprintf(s, "[%02d] Timer expire\n",e->handle);
		break;

	case VPB_TONE_DEBUG_END:
		sprintf(s, "[%02d] Tone detector debug end\n",e->handle);
		break;

	case VPB_VOXON:
		sprintf(s, "[%02d] Vox ON\n",e->handle);
		break;

	case VPB_VOXOFF:
		sprintf(s, "[%02d] Vox OFF\n",e->handle);
		break;

	case VPB_CALLEND:
		break;

	case VPB_PLAY_UNDERFLOW:
		sprintf(s, "[%02d] Play fifo underflow\n",e->handle);
		break;

	case VPB_RECORD_OVERFLOW:
		sprintf(s, "[%02d] Record fifo overflow\n",e->handle);
		break;

	case VPB_DTMF:
		sprintf(s, "[%02d] DTMF digit: %c\n",e->handle, (char)e->data);
		break;

	default:
		sprintf(s, "undefined event code\n");  // should never get here
		break;
	}
	
	// make sure we havent made s[] to long

	assert(strlen(s) < (VPB_MAX_STR-1));
}
