/*---------------------------------------------------------------------------*\

	FILE....: CONFIG.H
	TYPE....: C Header File
	AUTHOR..: David Rowe
	DATE....: 28/11/97

	Helper functions for talking to the VPB config manager.

\*--------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

	Copyright (C) 1999 Voicetronix Pty Ltd

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

\*---------------------------------------------------------------------------*/

#ifndef __CONFIG__
#define __CONFIG__

#include "contypes.h"
#include "comm.h"

#define	CONFIG_MAX_LIST		10

/*--------------------------------------------------------------------------*\

				FUNCTIONS

\*--------------------------------------------------------------------------*/

void config_create_object(Comm *c, ushort board, ushort cls, ushort id, 
			  ushort ch, ushort data);
void config_create_wire(Comm *c, ushort board, ushort src, ushort dest);
void config_clear(Comm *c, ushort board);
void config_run(Comm *c, ushort board);
void config_stop(Comm *c, ushort board);
void config_clear_wire(Comm *c, ushort board, ushort obj);
void config_disable_object(Comm *c, ushort board, ushort obj);
void config_enable_object(Comm *c, ushort board, ushort obj);
void config_enable_two_objects(Comm *c, ushort board, ushort obj1,
			       ushort obj2);
void config_rate8k(Comm *c, ushort board, ushort obj);
void config_rate6k(Comm *c, ushort board, ushort obj);
void config_packrate(Comm *c, ushort board, ushort obj, ushort packrate);
void config_adpcm_reset(Comm *c, ushort board, ushort obj);
void config_connect_to_zerobuf(Comm *c, ushort board, ushort obj);
void config_flush_fifo(Comm *c, ushort board, ushort obj);
void config_toneg_reset(Comm *c, ushort board, ushort obj);
void config_reset_fifo_alarm(Comm *c, ushort board, ushort obj);
void config_enable_object_list(Comm *c, ushort board, ushort objlist[], 
			       int nobj);

#endif	/* __CONFIG__ */
