
/*---------------------------------------------------------------------------*\

    FILE....: VPBHANDLE.CPP
    TYPE....: C++ Function
    AUTHOR..: John Kostogiannis
    DATE....: 6/11/97

    Functions used to determine the device handle.

\*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

	Copyright (C) 1999 Voicetronix Pty Ltd

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

\*---------------------------------------------------------------------------*/

#include "config.h"

#include <assert.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "vpbhandle.h"
#include "vpbreg.h"
#include "mapdev.h"

/*-------------------------------------------------------------------------*\

							DEFINES

\*-------------------------------------------------------------------------*/

#define VPBHANDLE_FAIL		-1
#define VPBHANDLE_SUCCESS	0

/*-------------------------------------------------------------------------*\

			     FUNCTION HEADERS

\*-------------------------------------------------------------------------*/

int split(char s[], char brdcomp[], char chncomp[]);

/*-------------------------------------------------------------------------*\

				FUNCTIONS
	
\*-------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*\

	FUNCTION.: VPBHandle()
	AUTHOR...: John Kostogiannis
	DATE.....: 24/11/97

        Functions used to determine the device handle given the Dialogic style
	board/channel specification string.

\*--------------------------------------------------------------------------*/

void VPBHandle(ushort brdnum, ushort chnum,int *handle, VPBREG *reg,
	       ushort numbrds)
/*      char    *devmane;	ptr to device name		*/
/*	int     *handle;	ptr to channel handle		*/
/*	VPBREG	*reg;	        ptr to regsitry info		*/
/*      ushort  numbrds;	number of boards in system	*/
{
	VPBREG	*preg;
	
	preg = reg;
		
	if((brdnum>numbrds) || (brdnum < 1))
		assert(0); // VPBHANDLE_BOARD_NUMBER
	
	preg = preg+brdnum-1;
	if((chnum>preg->numch) || (brdnum < 1))
		assert(0); // VPBHANDLE_CHANNEL_NUMBER
	
	/* map board and channel number equivalent to driver number */

	brdnum -=1;
	chnum -=1;
	*handle = mapdevtohndle(brdnum,chnum);
}




