/*---------------------------------------------------------------------------*\

    FILE....: VPBREG.H
    TYPE....: C Header File
    AUTHOR..: David Rowe
    DATE....: 3/10/97

    Functions used to load configuration database from the PC into the
    VPB DSP.  This database is known as the DSP Registry.  Each VPB has its
    own registry.

\*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

	Copyright (C) 1999 Voicetronix Pty Ltd

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

\*---------------------------------------------------------------------------*/

#ifndef __VPBREG__
#define __VPBREG__

#include "contypes.h"
#include "dspfifo.h"

/*--------------------------------------------------------------------------*\

				DEFINES

\*--------------------------------------------------------------------------*/

// general defines 

#define	MAXCH		32	// max channels per VPB			

// channel status flags 

#define	RX		0x1	// channel receiving speech		
#define	TX		0x2	// channel transmitting speech		

/*--------------------------------------------------------------------------*\

				TYPEDEFS

\*--------------------------------------------------------------------------*/

// make sure compiler doesnt piss about with member alignment

#pragma pack(1)

// structure containing DSP program "registry" info for each VPB 

typedef struct {

	// info below stored in same format on DSP 

	ushort	data;		// data reg for PC-DSP comms		
	ushort	numch;		// number of channels			
	ushort	chstat[MAXCH];	// status of each channel		
	ushort	a_dnmess;	// addr of "down" message FIFO in DSP	
	ushort	a_upmess;	// addr of "up" message FIFO in DSP	
	ushort  szmess;		// size in words of message FIFOs	
	ushort  a_rxdf[MAXCH];	// addresses of RX FIFOs in DSP		
	ushort	a_txdf[MAXCH];	// addresses of TX FIFOs in DSP		
	ushort  szrxdf[MAXCH];	// size of RX FIFOs in DSP		
	ushort	sztxdf[MAXCH];	// size of TX FIFOs in DSP		
	ushort	lsf;		// length of superframe in words	

	// PC specific info 
	
	ushort	base;		// base address of VPB			
	char	firm[MAX_STR];	// firmware path and file name
	DspFifo *dnmess;	// ptr to down message DSP FIFO in PC	
	DspFifo *upmess;	// ptr to down message DSP FIFO in PC	
	DspFifo *rxdf[MAXCH];	// ptrs to RX DSP FIFO info in PC	
	DspFifo	*txdf[MAXCH];	// ptrs to TX DSP FIFO info in PC
	ushort  model;		// VPB model
	ushort  ddmodel;	// VPB Device Driver model
	ulong	szRelayBuf;	// size of PC side of relay buffer in words
				// note this same size is use for all DSP
				// fifos, ie message Qs and sample fifos
} VPBREG;

#pragma pack()	// back to default alignment

/*-------------------------------------------------------------------------*\

			    FUNCTION HEADERS

\*-------------------------------------------------------------------------*/

class VPBRegister {
public:
	VPBREG	*reg;
	VPBRegister(ushort *num);
	~VPBRegister();
};

void vpbreg_load_default_tones(int numch);
int vpbreg_config(int num_cards, int *bases, char *firmware_file);

#endif	/* #ifndef __VPBREG__	*/

